package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;
import cn.ibizlab.core.sample.service.IBIZSoftwareSuitService;
import cn.ibizlab.core.sample.mapper.IBIZSoftwareSuitMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.service.IBIZUNIProductService;


/**
 * 实体[软件] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSoftwareSuitService")
public class IBIZSoftwareSuitServiceBase extends ServiceImpl<IBIZSoftwareSuitMapper,IBIZSoftwareSuit> implements IBIZSoftwareSuitService {

    @Autowired
    @Lazy
    protected IBIZUNIProductService ibizuniProductService;
   
    @Autowired
    @Lazy
    protected cn.ibizlab.core.sample.mapping.IBIZSoftwareSuitInheritMapping ibizSoftwareSuitInheritMapping;

    protected int batchSize = 500;

    public IBIZSoftwareSuit get(IBIZSoftwareSuit et) {
        IBIZSoftwareSuit rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,软件:"+et.getIbizSoftwareSuitId());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSoftwareSuit> getByEntities(List<IBIZSoftwareSuit> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZSoftwareSuit getDraft(IBIZSoftwareSuit et) {
        return et;
    }

    public Integer checkKey(IBIZSoftwareSuit et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSoftwareSuitId())) && this.count(Wrappers.<IBIZSoftwareSuit>query().eq("ibizsoftwaresuitid", et.getIbizSoftwareSuitId()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSoftwareSuit et) {
        if(ObjectUtils.isEmpty(et.getIbizSoftwareSuitId()))
            et.setIbizSoftwareSuitId((String)et.getDefaultKey(true));
        IBIZUNIProduct ibizuniProduct = ibizSoftwareSuitInheritMapping.toIbizuniProduct(et);
        ibizuniProductService.create(ibizuniProduct);

        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSoftwareSuit> list) {
        for (IBIZSoftwareSuit et : list) {
            getSelf().create(et);
        }
        return true;
    }

    @Transactional
    public boolean update(IBIZSoftwareSuit et) {
        IBIZUNIProduct ibizuniProduct = ibizSoftwareSuitInheritMapping.toIbizuniProduct(et);
        ibizuniProductService.save(ibizuniProduct);

        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsoftwaresuitid", et.getIbizSoftwareSuitId());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSoftwareSuit> list) {
        for (IBIZSoftwareSuit et : list) {
            getSelf().update(et);
        }
        return true;
    }

    @Transactional
    public boolean save(IBIZSoftwareSuit et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSoftwareSuit> list) {
        List<IBIZSoftwareSuit> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSoftwareSuitId();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSoftwareSuit> _create=new ArrayList<>();
        List<IBIZSoftwareSuit> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSoftwareSuitId();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSoftwareSuit et) {
        String key = et.getIbizSoftwareSuitId();
        ibizuniProductService.remove(ibizSoftwareSuitInheritMapping.toIbizuniProduct(et));


        if(!remove(new QueryWrapper<IBIZSoftwareSuit>()
                .eq("ibizsoftwaresuitid", et.getIbizSoftwareSuitId())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSoftwareSuit> entities) {
        for (IBIZSoftwareSuit et : entities) {
            if(!getSelf().remove(et))
                return false;
        }
        return true;
    }

    public Page<IBIZSoftwareSuit> searchDefault(IBIZSoftwareSuitSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSoftwareSuit> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSoftwareSuit>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSoftwareSuit> listDefault(IBIZSoftwareSuitSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }