package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;
import cn.ibizlab.core.sample.service.IBIZSample0011Service;
import cn.ibizlab.core.sample.mapper.IBIZSample0011Mapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.service.IBIZSample0010Service;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.service.IBIZUNIProductService;


/**
 * 实体[订单明细] 服务对象接口实现
 */
@Slf4j
@Service("IBIZSample0011Service")
public class IBIZSample0011ServiceBase extends ServiceImpl<IBIZSample0011Mapper,IBIZSample0011> implements IBIZSample0011Service {

    @Autowired
    @Lazy
    protected IBIZSample0010Service ibizSample0010Service;
   
    @Autowired
    @Lazy
    protected IBIZUNIProductService ibizuniProductService;
   

    protected int batchSize = 500;

    public IBIZSample0011 get(IBIZSample0011 et) {
        IBIZSample0011 rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,订单明细:"+et.getIbizSample0011Id());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZSample0011> getByEntities(List<IBIZSample0011> entities) {
        return this.baseMapper.selectEntities(entities);
    }

    public void fillParentData(IBIZSample0011 et) {
        if(!ObjectUtils.isEmpty(et.getIbizSample0010Id())) {
            IBIZSample0010 ibizSample0010 = et.getIbizsample0010();
            if(!ObjectUtils.isEmpty(ibizSample0010)) {
                et.setIbizSample0010Name(ibizSample0010.getIbizSample0010Name());   
            }
        }    
        if(!ObjectUtils.isEmpty(et.getIbizuniProductId())) {
            IBIZUNIProduct ibizuniProduct = et.getIbizuniproduct();
            if(!ObjectUtils.isEmpty(ibizuniProduct)) {
                et.setIbizuniProductName(ibizuniProduct.getIbizuniProductName());   
                et.setUnitPrice(ibizuniProduct.getUnitPrice());   
                et.setUnit(ibizuniProduct.getUnit());   
            }
        }    
    }

    public IBIZSample0011 getDraft(IBIZSample0011 et) {
        fillParentData(et);
        return et;
    }

    public Integer checkKey(IBIZSample0011 et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizSample0011Id())) && this.count(Wrappers.<IBIZSample0011>query().eq("ibizsample0011id", et.getIbizSample0011Id()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZSample0011 et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZSample0011> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZSample0011 et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizsample0011id", et.getIbizSample0011Id());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZSample0011> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZSample0011 et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZSample0011> list) {
        List<IBIZSample0011> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizSample0011Id();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZSample0011> _create=new ArrayList<>();
        List<IBIZSample0011> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizSample0011Id();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZSample0011 et) {
        String key = et.getIbizSample0011Id();

        if(!remove(new QueryWrapper<IBIZSample0011>()
                .eq("ibizsample0011id", et.getIbizSample0011Id())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZSample0011> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZSample0011> searchDefault(IBIZSample0011SearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZSample0011> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZSample0011>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZSample0011> listDefault(IBIZSample0011SearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }

    public List<IBIZSample0011> selectByIbizSample0010Id(String ibizSample0010Id) {
        return baseMapper.selectByIbizSample0010Id(ibizSample0010Id);
    }

    public boolean removeByIbizSample0010Id(String ibizSample0010Id) {
        return this.remove(new QueryWrapper<IBIZSample0011>().eq("ibizsample0010id",ibizSample0010Id));
    }

    public boolean resetByIbizSample0010Id(String ibizSample0010Id) {
        return this.update(new UpdateWrapper<IBIZSample0011>().set("ibizsample0010id",null).eq("ibizsample0010id",ibizSample0010Id));
    }

    public boolean saveByIbizsample0010(IBIZSample0010 ibizSample0010,List<IBIZSample0011> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0011> _update=new ArrayList<IBIZSample0011>();
        List<IBIZSample0011> _create=new ArrayList<IBIZSample0011>();
        for(IBIZSample0011 before:selectByIbizSample0010Id(ibizSample0010.getIbizSample0010Id())){
            delIds.add(before.getIbizSample0011Id());
        }
        for(IBIZSample0011 sub:list) {
            sub.setIbizSample0010Id(ibizSample0010.getIbizSample0010Id());
            sub.setIbizsample0010(ibizSample0010);
            if(ObjectUtils.isEmpty(sub.getIbizSample0011Id()))
                sub.setIbizSample0011Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0011Id())) {
                delIds.remove(sub.getIbizSample0011Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }

    public List<IBIZSample0011> selectByIbizuniProductId(String ibizuniProductId) {
        return baseMapper.selectByIbizuniProductId(ibizuniProductId);
    }

    public boolean removeByIbizuniProductId(String ibizuniProductId) {
        return this.remove(new QueryWrapper<IBIZSample0011>().eq("ibizuniproductid",ibizuniProductId));
    }

    public boolean resetByIbizuniProductId(String ibizuniProductId) {
        return this.update(new UpdateWrapper<IBIZSample0011>().set("ibizuniproductid",null).eq("ibizuniproductid",ibizuniProductId));
    }

    public boolean saveByIbizuniproduct(IBIZUNIProduct ibizuniProduct,List<IBIZSample0011> list) {
        if(list==null)
            return true;
        Set<String> delIds=new HashSet<String>();
        List<IBIZSample0011> _update=new ArrayList<IBIZSample0011>();
        List<IBIZSample0011> _create=new ArrayList<IBIZSample0011>();
        for(IBIZSample0011 before:selectByIbizuniProductId(ibizuniProduct.getIbizuniProductId())){
            delIds.add(before.getIbizSample0011Id());
        }
        for(IBIZSample0011 sub:list) {
            sub.setIbizuniProductId(ibizuniProduct.getIbizuniProductId());
            sub.setIbizuniproduct(ibizuniProduct);
            if(ObjectUtils.isEmpty(sub.getIbizSample0011Id()))
                sub.setIbizSample0011Id((String)sub.getDefaultKey(true));
            if(delIds.contains(sub.getIbizSample0011Id())) {
                delIds.remove(sub.getIbizSample0011Id());
                _update.add(sub);
            }
            else
                _create.add(sub);
        }
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        if(delIds.size()>0 && (!getSelf().removeBatch(delIds)))
            return false;
        return true;
    }





    }