package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZQJ;
import cn.ibizlab.core.sample.filter.IBIZQJSearchContext;
import cn.ibizlab.core.sample.service.IBIZQJService;
import cn.ibizlab.core.sample.mapper.IBIZQJMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[请假] 服务对象接口实现
 */
@Slf4j
@Service("IBIZQJService")
public class IBIZQJServiceBase extends ServiceImpl<IBIZQJMapper,IBIZQJ> implements IBIZQJService {


    protected int batchSize = 500;

    public IBIZQJ get(IBIZQJ et) {
        IBIZQJ rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,请假:"+et.getIbizqjid());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZQJ> getByEntities(List<IBIZQJ> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZQJ getDraft(IBIZQJ et) {
        return et;
    }

    public Integer checkKey(IBIZQJ et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizqjid())) && this.count(Wrappers.<IBIZQJ>query().eq("ibizqjid", et.getIbizqjid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZQJ et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZQJ> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZQJ et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizqjid", et.getIbizqjid());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZQJ> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZQJ et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZQJ> list) {
        List<IBIZQJ> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizqjid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZQJ> _create=new ArrayList<>();
        List<IBIZQJ> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizqjid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZQJ et) {
        String key = et.getIbizqjid();

        if(!remove(new QueryWrapper<IBIZQJ>()
                .eq("ibizqjid", et.getIbizqjid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZQJ> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZQJ> searchDefault(IBIZQJSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZQJ> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZQJ>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZQJ> listDefault(IBIZQJSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }