package cn.ibizlab.core.sample.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Map;
import java.util.HashSet;
import java.util.HashMap;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.math.BigInteger;
import lombok.extern.slf4j.Slf4j;

import cn.ibizlab.util.security.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.Assert;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEDITORSearchContext;
import cn.ibizlab.core.sample.service.IBIZAPPEDITORService;
import cn.ibizlab.core.sample.mapper.IBIZAPPEDITORMapper;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.AuthenticationUser;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.conditions.Wrapper;


/**
 * 实体[编辑器] 服务对象接口实现
 */
@Slf4j
@Service("IBIZAPPEDITORService")
public class IBIZAPPEDITORServiceBase extends ServiceImpl<IBIZAPPEDITORMapper,IBIZAPPEDITOR> implements IBIZAPPEDITORService {


    protected int batchSize = 500;

    public IBIZAPPEDITOR get(IBIZAPPEDITOR et) {
        IBIZAPPEDITOR rt = this.baseMapper.selectEntity(et);
        Assert.notNull(rt,"数据不存在,编辑器:"+et.getIbizappeditorid());
        BeanUtils.copyProperties(rt, et);
        return et;
    }
    
    public List<IBIZAPPEDITOR> getByEntities(List<IBIZAPPEDITOR> entities) {
        return this.baseMapper.selectEntities(entities);
    }


    public IBIZAPPEDITOR getDraft(IBIZAPPEDITOR et) {
        return et;
    }

    public Integer checkKey(IBIZAPPEDITOR et) {
        return ( (!ObjectUtils.isEmpty(et.getIbizappeditorid())) && this.count(Wrappers.<IBIZAPPEDITOR>query().eq("ibizappeditorid", et.getIbizappeditorid()))>0 )?1:0;
    }

    @Override
    @Transactional
    public boolean create(IBIZAPPEDITOR et) {
        if(!this.retBool(this.baseMapper.insert(et))) 
            return false;
        get(et);
        return true;
    }
    @Transactional
    public boolean createBatch(List<IBIZAPPEDITOR> list) {
        this.saveBatch(list, batchSize);
        return true;
    }

    @Transactional
    public boolean update(IBIZAPPEDITOR et) {
        UpdateWrapper qw=et.getUpdateWrapper(true);
        qw.eq("ibizappeditorid", et.getIbizappeditorid());
        if(!update(et, qw)) {
            return false;
        }
        get(et);
        return true;
    }

    @Transactional
    public boolean updateBatch(List<IBIZAPPEDITOR> list) {
        updateBatchById(list, batchSize);
        return true;
    }

    @Transactional
    public boolean save(IBIZAPPEDITOR et) {
        if(checkKey(et)>0)
            return getSelf().update(et);
        else
            return getSelf().create(et);
    }

    @Transactional
    public boolean saveBatch(List<IBIZAPPEDITOR> list) {
        List<IBIZAPPEDITOR> rt=this.getByEntities(list);
        Set<Serializable> keys=new HashSet<>();
        rt.forEach(et->{
            Serializable key = et.getIbizappeditorid();
            if(!ObjectUtils.isEmpty(key))
                keys.add(key);
        });
        List<IBIZAPPEDITOR> _create=new ArrayList<>();
        List<IBIZAPPEDITOR> _update=new ArrayList<>();
        list.forEach(et-> {
            Serializable key = et.getIbizappeditorid();
            if(keys.contains(key))
                _update.add(et);
            else
                _create.add(et);
        });
        List rtList=new ArrayList<>();
        if(_update.size()>0 && (!getSelf().updateBatch(_update)))
            return false;
        if(_create.size()>0 && (!getSelf().createBatch(_create)))
            return false;
        return true;
    }

    @Transactional
    public boolean remove(IBIZAPPEDITOR et) {
        String key = et.getIbizappeditorid();

        if(!remove(new QueryWrapper<IBIZAPPEDITOR>()
                .eq("ibizappeditorid", et.getIbizappeditorid())
            )) {
            return false;
        }
        return true ;
    }

    @Transactional
    public boolean removeByEntities(List<IBIZAPPEDITOR> entities) {
        this.baseMapper.deleteEntities(entities);
        return true;
    }

    public Page<IBIZAPPEDITOR> searchDefault(IBIZAPPEDITORSearchContext context) {
        com.baomidou.mybatisplus.extension.plugins.pagination.Page<IBIZAPPEDITOR> pages=baseMapper.searchDefault(context.getPages(),context,context.getSelectCond());
        return new PageImpl<IBIZAPPEDITOR>(pages.getRecords(), context.getPageable(), pages.getTotal());
    }
    public List<IBIZAPPEDITOR> listDefault(IBIZAPPEDITORSearchContext context) {
        return baseMapper.listDefault(context,context.getSelectCond());
    }





    }