package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0008;
import cn.ibizlab.core.sample.filter.IBIZSample0008SearchContext;

public interface IBIZSample0008Service extends IService<IBIZSample0008> {

    default IBIZSample0008Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0008 get(IBIZSample0008 et);
    default IBIZSample0008 get(String key) {
        IBIZSample0008 et = new IBIZSample0008();
        et.setIbizSample0008Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0008> getByIds(Collection<String> ids) {
        List<IBIZSample0008> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0008 et = new IBIZSample0008();
            et.setIbizSample0008Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0008> getByEntities(List<IBIZSample0008> entities);

    IBIZSample0008 getDraft(IBIZSample0008 et);

    Integer checkKey(IBIZSample0008 et);

    boolean create(IBIZSample0008 et);
    boolean createBatch(List<IBIZSample0008> list);

    boolean update(IBIZSample0008 et);
    boolean updateBatch(List<IBIZSample0008> list);

    boolean save(IBIZSample0008 et);
    boolean saveBatch(List<IBIZSample0008> list);

    default boolean remove(String key) {
        IBIZSample0008 et = new IBIZSample0008();
        et.setIbizSample0008Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0008 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0008> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0008 et = new IBIZSample0008();
            et.setIbizSample0008Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0008> entities);

    Page<IBIZSample0008> searchDefault(IBIZSample0008SearchContext context);
    List<IBIZSample0008> listDefault(IBIZSample0008SearchContext context);

}