package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZAPPVIEW;
import cn.ibizlab.core.sample.filter.IBIZAPPVIEWSearchContext;

public interface IBIZAPPVIEWService extends IService<IBIZAPPVIEW> {

    default IBIZAPPVIEWService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZAPPVIEW get(IBIZAPPVIEW et);
    default IBIZAPPVIEW get(String key) {
        IBIZAPPVIEW et = new IBIZAPPVIEW();
        et.setIbizappviewid(key);
        return getSelf().get(et);
    }
    default List<IBIZAPPVIEW> getByIds(Collection<String> ids) {
        List<IBIZAPPVIEW> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPVIEW et = new IBIZAPPVIEW();
            et.setIbizappviewid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZAPPVIEW> getByEntities(List<IBIZAPPVIEW> entities);

    IBIZAPPVIEW getDraft(IBIZAPPVIEW et);

    Integer checkKey(IBIZAPPVIEW et);

    boolean create(IBIZAPPVIEW et);
    boolean createBatch(List<IBIZAPPVIEW> list);

    boolean update(IBIZAPPVIEW et);
    boolean updateBatch(List<IBIZAPPVIEW> list);

    boolean save(IBIZAPPVIEW et);
    boolean saveBatch(List<IBIZAPPVIEW> list);

    default boolean remove(String key) {
        IBIZAPPVIEW et = new IBIZAPPVIEW();
        et.setIbizappviewid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZAPPVIEW et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZAPPVIEW> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPVIEW et = new IBIZAPPVIEW();
            et.setIbizappviewid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZAPPVIEW> entities);

    Page<IBIZAPPVIEW> searchDefault(IBIZAPPVIEWSearchContext context);
    List<IBIZAPPVIEW> listDefault(IBIZAPPVIEWSearchContext context);

}