package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0018", resultMap = "IBIZSample0018ResultMap")
@ApiModel(value = "IBIZSAMPLE0018", description = "示例实体18")
public class IBIZSample0018 extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 示例实体04标识
     */
    @Id
    @TableId(value = "ibizsample0018id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0018id" , isKeyField = true)
    @JsonProperty("ibizsample0018id")
    @JSONField(name = "ibizsample0018id")
    @ApiModelProperty(value = "ibizsample0018id", notes = "示例实体04标识")
    private String ibizSample0018Id;

    /**
     * 序号
     */
    @TableField(value = "sn")
    @DEField(name = "sn")
    @JsonProperty("sn")
    @JSONField(name = "sn")
    @ApiModelProperty(value = "sn", notes = "序号")
    private Integer sn;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 示例实体04名称
     */
    @TableField(value = "ibizsample0018name")
    @DEField(name = "ibizsample0018name")
    @JsonProperty("ibizsample0018name")
    @JSONField(name = "ibizsample0018name")
    @ApiModelProperty(value = "ibizsample0018name", notes = "示例实体04名称")
    private String ibizSample0018Name;

    /**
     * 图片
     */
    @TableField(value = "image")
    @DEField(name = "image")
    @JsonProperty("image")
    @JSONField(name = "image")
    @ApiModelProperty(value = "image", notes = "图片")
    private String image;

    /**
     * 描述
     */
    @TableField(value = "description")
    @DEField(name = "description")
    @JsonProperty("description")
    @JSONField(name = "description")
    @ApiModelProperty(value = "description", notes = "描述")
    private String description;






    /**
     * 设置 [序号]
     */
    public void setSn(Integer sn) {
        this.sn = sn;
        this.modify("sn", sn);
    }




    /**
     * 设置 [示例实体04名称]
     */
    public void setIbizSample0018Name(String ibizSample0018Name) {
        this.ibizSample0018Name = ibizSample0018Name;
        this.modify("ibizsample0018name", ibizSample0018Name);
    }

    /**
     * 设置 [图片]
     */
    public void setImage(String image) {
        this.image = image;
        this.modify("image", image);
    }

    /**
     * 设置 [描述]
     */
    public void setDescription(String description) {
        this.description = description;
        this.modify("description", description);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0018id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}