package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZSAMPLE0005", resultMap = "IBIZSample0005ResultMap")
@ApiModel(value = "IBIZSAMPLE0005", description = "多模式流程")
public class IBIZSample0005 extends EntityMP implements Serializable
{

    /**
     * 订单金额
     */
    @TableField(value = "je")
    @DEField(name = "je")
    @JsonProperty("je")
    @JSONField(name = "je")
    @ApiModelProperty(value = "je", notes = "订单金额")
    private BigDecimal je;

    /**
     * 工作流实例
     */
    @TableField(value = "wfinstanceid")
    @DEField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty(value = "wfinstanceid", notes = "工作流实例")
    private String wfInstanceId;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 订单时间
     */
    @TableField(value = "mmdate")
    @DEField(name = "mmdate")
    @JsonProperty("mmdate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "mmdate" , format = "yyyy-MM-dd")
    @ApiModelProperty(value = "mmdate", notes = "订单时间")
    private Timestamp mmDate;

    /**
     * 多模式流程标识
     */
    @Id
    @TableId(value = "ibizsample0005id" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizsample0005id" , isKeyField = true)
    @JsonProperty("ibizsample0005id")
    @JSONField(name = "ibizsample0005id")
    @ApiModelProperty(value = "ibizsample0005id", notes = "多模式流程标识")
    private String ibizSample0005Id;

    /**
     * 工作流版本
     */
    @TableField(value = "wfversion")
    @DEField(name = "wfversion")
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty(value = "wfversion", notes = "工作流版本")
    private String wfVersion;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfmmstep")
    @DEField(name = "wfmmstep" , dict = "WFMMSTEP")
    @JsonProperty("wfmmstep")
    @JSONField(name = "wfmmstep")
    @ApiModelProperty(value = "wfmmstep", notes = "工作流步骤")
    private String wfmmStep;

    /**
     * 订单类型
     */
    @TableField(value = "wfmmtype")
    @DEField(name = "wfmmtype" , dict = "ORDERTYPE")
    @JsonProperty("wfmmtype")
    @JSONField(name = "wfmmtype")
    @ApiModelProperty(value = "wfmmtype", notes = "订单类型")
    private String wfmmType;

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 工作流步骤
     */
    @TableField(value = "wfstate")
    @DEField(name = "wfstate" , dict = "WFStates")
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty(value = "wfstate", notes = "工作流步骤")
    private Integer wfState;

    /**
     * 多模式流程名称
     */
    @TableField(value = "ibizsample0005name")
    @DEField(name = "ibizsample0005name")
    @JsonProperty("ibizsample0005name")
    @JSONField(name = "ibizsample0005name")
    @ApiModelProperty(value = "ibizsample0005name", notes = "多模式流程名称")
    private String ibizSample0005Name;

    /**
     * 备注
     */
    @TableField(value = "memo")
    @DEField(name = "memo")
    @JsonProperty("memo")
    @JSONField(name = "memo")
    @ApiModelProperty(value = "memo", notes = "备注")
    private String memo;

    /**
     * 状态
     */
    @TableField(value = "wfmmstate")
    @DEField(name = "wfmmstate" , dict = "WFSTATE")
    @JsonProperty("wfmmstate")
    @JSONField(name = "wfmmstate")
    @ApiModelProperty(value = "wfmmstate", notes = "状态")
    private String wfmmState;




    /**
     * 设置 [订单金额]
     */
    public void setJe(BigDecimal je) {
        this.je = je;
        this.modify("je", je);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }


    /**
     * 设置 [订单时间]
     */
    public void setMmDate(Timestamp mmDate) {
        this.mmDate = mmDate;
        this.modify("mmdate", mmDate);
    }


    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }



    /**
     * 设置 [工作流步骤]
     */
    public void setWfmmStep(String wfmmStep) {
        this.wfmmStep = wfmmStep;
        this.modify("wfmmstep", wfmmStep);
    }

    /**
     * 设置 [订单类型]
     */
    public void setWfmmType(String wfmmType) {
        this.wfmmType = wfmmType;
        this.modify("wfmmtype", wfmmType);
    }


    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [多模式流程名称]
     */
    public void setIbizSample0005Name(String ibizSample0005Name) {
        this.ibizSample0005Name = ibizSample0005Name;
        this.modify("ibizsample0005name", ibizSample0005Name);
    }

    /**
     * 设置 [备注]
     */
    public void setMemo(String memo) {
        this.memo = memo;
        this.modify("memo", memo);
    }

    /**
     * 设置 [状态]
     */
    public void setWfmmState(String wfmmState) {
        this.wfmmState = wfmmState;
        this.modify("wfmmstate", wfmmState);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizsample0005id");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}