package cn.ibizlab.core.sample.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.Assert;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.annotation.Audit;
import cn.ibizlab.util.enums.DupCheck;
import cn.ibizlab.util.domain.EntityMP;
import java.io.Serializable;
import lombok.*;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Transient;
import org.springframework.data.annotation.Id;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;

@Getter
@Setter
@NoArgsConstructor
@JsonIgnoreProperties(value = "handler")
@TableName(value = "T_IBIZAPPEXTENDEDITOR", resultMap = "IBIZAPPEXTENDEDITORResultMap")
@ApiModel(value = "IBIZAPPEXTENDEDITOR", description = "扩展编辑器")
public class IBIZAPPEXTENDEDITOR extends EntityMP implements Serializable
{

    /**
     * 建立人
     */
    @TableField(value = "createman" , fill = FieldFill.INSERT)
    @DEField(name = "createman" , preType = DEPredefinedFieldType.CREATEMAN , dict = "SysOperator")
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty(value = "createman", notes = "建立人")
    private String createMan;

    /**
     * 更新时间
     */
    @TableField(value = "updatedate")
    @DEField(name = "updatedate" , preType = DEPredefinedFieldType.UPDATEDATE)
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "updatedate", notes = "更新时间")
    private Timestamp updateDate;

    /**
     * 建立时间
     */
    @TableField(value = "createdate" , fill = FieldFill.INSERT)
    @DEField(name = "createdate" , preType = DEPredefinedFieldType.CREATEDATE)
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "createdate", notes = "建立时间")
    private Timestamp createDate;

    /**
     * 更新人
     */
    @TableField(value = "updateman")
    @DEField(name = "updateman" , preType = DEPredefinedFieldType.UPDATEMAN , dict = "SysOperator")
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty(value = "updateman", notes = "更新人")
    private String updateMan;

    /**
     * 扩展编辑器名称
     */
    @TableField(value = "ibizappextendeditorname")
    @DEField(name = "ibizappextendeditorname")
    @JsonProperty("ibizappextendeditorname")
    @JSONField(name = "ibizappextendeditorname")
    @ApiModelProperty(value = "ibizappextendeditorname", notes = "扩展编辑器名称")
    private String ibizappextendeditorName;

    /**
     * 扩展编辑器标识
     */
    @Id
    @TableId(value = "ibizappextendeditorid" , type = IdType.ASSIGN_UUID)
    @DEField(name = "ibizappextendeditorid" , isKeyField = true)
    @JsonProperty("ibizappextendeditorid")
    @JSONField(name = "ibizappextendeditorid")
    @ApiModelProperty(value = "ibizappextendeditorid", notes = "扩展编辑器标识")
    private String ibizappextendeditorid;

    /**
     * 扩展标识
     */
    @TableField(value = "extensionflag")
    @DEField(name = "extensionflag")
    @JsonProperty("extensionflag")
    @JSONField(name = "extensionflag")
    @ApiModelProperty(value = "extensionflag", notes = "扩展标识")
    private String extensionflag;

    /**
     * 文档地址
     */
    @TableField(value = "documentaddress")
    @DEField(name = "documentaddress")
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty(value = "documentaddress", notes = "文档地址")
    private String documentaddress;

    /**
     * 扩展编辑器描述
     */
    @TableField(value = "extendeditordescription")
    @DEField(name = "extendeditordescription")
    @JsonProperty("extendeditordescription")
    @JSONField(name = "extendeditordescription")
    @ApiModelProperty(value = "extendeditordescription", notes = "扩展编辑器描述")
    private String extendeditordescription;

    /**
     * 数量
     */
    @TableField(value = "amount")
    @DEField(name = "amount")
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty(value = "amount", notes = "数量")
    private Integer amount;

    /**
     * 扩展编辑器类型
     */
    @TableField(value = "extendeditortype")
    @DEField(name = "extendeditortype" , dict = "CodeList43")
    @JsonProperty("extendeditortype")
    @JSONField(name = "extendeditortype")
    @ApiModelProperty(value = "extendeditortype", notes = "扩展编辑器类型")
    private String extendeditortype;








    /**
     * 设置 [扩展编辑器名称]
     */
    public void setIbizappextendeditorName(String ibizappextendeditorName) {
        this.ibizappextendeditorName = ibizappextendeditorName;
        this.modify("ibizappextendeditorname", ibizappextendeditorName);
    }


    /**
     * 设置 [扩展标识]
     */
    public void setExtensionflag(String extensionflag) {
        this.extensionflag = extensionflag;
        this.modify("extensionflag", extensionflag);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [扩展编辑器描述]
     */
    public void setExtendeditordescription(String extendeditordescription) {
        this.extendeditordescription = extendeditordescription;
        this.modify("extendeditordescription", extendeditordescription);
    }

    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [扩展编辑器类型]
     */
    public void setExtendeditortype(String extendeditortype) {
        this.extendeditortype = extendeditortype;
        this.modify("extendeditortype", extendeditortype);
    }



    

    /**
     * 复制当前对象数据到目标对象(粘贴重置)
     * @param targetEntity 目标数据对象
     * @param bIncEmpty  是否包括空值
     * @param <T>
     * @return
     */
    @Override
    public <T> T copyTo(T targetEntity, boolean bIncEmpty) {
        this.reset("ibizappextendeditorid");        
        return super.copyTo(targetEntity, bIncEmpty);
    }    
}