package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0008DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("自循环流程")
public class IBIZSample0008DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 自循环流程标识
     */
    @JsonProperty("ibizsample0008id")
    @JSONField(name = "ibizsample0008id")
    @ApiModelProperty("自循环流程标识")
    private String ibizSample0008Id;

    /**
     * 自循环流程名称
     */
    @JsonProperty("ibizsample0008name")
    @JSONField(name = "ibizsample0008name")
    @ApiModelProperty("自循环流程名称")
    private String ibizSample0008Name;

    /**
     * 下一步处理人
     */
    @JsonProperty("nextperson")
    @JSONField(name = "nextperson")
    @ApiModelProperty("下一步处理人")
    private String nextPerson;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 工作流实例
     */
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty("工作流实例")
    private String wfInstanceId;

    /**
     * 工作流步骤
     */
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty("工作流步骤")
    private Integer wfState;

    /**
     * 自循环步骤
     */
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty("自循环步骤")
    private String wfStep;

    /**
     * 工作流版本
     */
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty("工作流版本")
    private String wfVersion;

    /**
     * 业务状态
     */
    @JsonProperty("ywstate")
    @JSONField(name = "ywstate")
    @ApiModelProperty("业务状态")
    private String ywState;


    /**
     * 设置 [自循环流程名称]
     */
    public void setIbizSample0008Name(String ibizSample0008Name) {
        this.ibizSample0008Name = ibizSample0008Name;
        this.modify("ibizsample0008name", ibizSample0008Name);
    }

    /**
     * 设置 [下一步处理人]
     */
    public void setNextPerson(String nextPerson) {
        this.nextPerson = nextPerson;
        this.modify("nextperson", nextPerson);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [自循环步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [业务状态]
     */
    public void setYwState(String ywState) {
        this.ywState = ywState;
        this.modify("ywstate", ywState);
    }


}
