import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'
const Random = Mock.Random;

// 获取应用数据
mock.onGet('v7/main-menuappmenu').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status, {
        name: 'appmenu',
        items:  [
            {
	id: 'F2B1A41D-AA1E-44D7-B676-C0A9F4DE1421',
	name: 'menuitem1',
	text: '工作台',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作台',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: true,
	iconcls: 'fa fa-jsfiddle',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc66',
	resourcetag: '',
},
            {
	id: '8EDED933-EF14-4240-9AF4-DF498ABBD32F',
	name: 'menuitem3',
	text: '控件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '控件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-cube',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '2CDE6082-3CD7-4774-A8EF-1F08CD032553',
	name: 'menuitem6',
	text: '默认数据类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '默认数据类型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto338',
	resourcetag: '',
},
		{
	id: 'F29E931C-8DCD-47CE-A95D-1548ADDAE9A0',
	name: 'menuitem7',
	text: '默认编辑器类型',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '默认编辑器类型',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto222',
	resourcetag: '',
},
		{
	id: 'DF31D3C9-DCE5-421F-AD8F-1968BF59CC41',
	name: 'menuitem72',
	text: '扩展编辑器',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '扩展编辑器',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc',
	resourcetag: '',
},
		{
	id: '8562CEA7-4825-4B4B-8B8B-79F03401247E',
	name: 'menuitem65',
	text: '微服务组件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '微服务组件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc89',
	resourcetag: '',
},
		{
	id: '0FF97C06-F9DF-4549-8006-BAB2C9A47EDE',
	name: 'menuitem151',
	text: '编辑器插件示例',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑器插件示例',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc70',
	resourcetag: '',
},
	],
},
            {
	id: 'DA448338-6B98-4E27-BAD3-78DB74361D10',
	name: 'menuitem4',
	text: '部件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '部件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-cubes',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '4F2EE87E-A486-405D-9A9A-4E8B756F42D1',
	name: 'menuitem112',
	text: '应用类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '782BC83B-6959-4F55-91E7-AEA11ECAE9DF',
	name: 'menuitem186',
	text: '数据看板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据看板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc50',
	resourcetag: '',
},
		{
	id: '94974D5B-6991-4FC1-977A-DFB4A40794A9',
	name: 'menuitem129',
	text: '门户部件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '门户部件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc82',
	resourcetag: '',
},
	],
},
		{
	id: '2307082D-6754-4384-985C-C0A7971FB646',
	name: 'menuitem156',
	text: '表单类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '1A158EF7-B79F-45F4-B0BF-74AF68B63229',
	name: 'menuitem12',
	text: '编辑表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'D4BFEDD3-A958-493E-99AD-4A237EB16320',
	name: 'menuitem15',
	text: '基础表单项',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '基础表单项',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto393',
	resourcetag: '',
},
		{
	id: 'C1AF85B3-0525-4721-AA33-A1779A113435',
	name: 'menuitem107',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc31',
	resourcetag: '',
},
		{
	id: '9E7CA0DC-525F-4686-BD0C-82170FB2B3E9',
	name: 'menuitem47',
	text: '新建默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '新建默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto319',
	resourcetag: '',
},
		{
	id: '55723CD2-A66E-4921-9D9D-21B79D677D9E',
	name: 'menuitem99',
	text: '更新默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更新默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc23',
	resourcetag: '',
},
		{
	id: '239E9CE3-D83B-4A80-8686-7711301451BD',
	name: 'menuitem48',
	text: '输入提示',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '输入提示',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto279',
	resourcetag: '',
},
		{
	id: 'FAB0C8B3-E626-417D-A54D-DA5DCF20937D',
	name: 'menuitem49',
	text: '辅助输入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '辅助输入',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto129',
	resourcetag: '',
},
		{
	id: '86D86FDD-E77E-412A-A16C-B4079998EE65',
	name: 'menuitem50',
	text: '自动填充',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动填充',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto371',
	resourcetag: '',
},
		{
	id: '96DEDE42-DD44-412C-99BF-63B97BC7B152',
	name: 'menuitem51',
	text: '超链接',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '超链接',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto111',
	resourcetag: '',
},
		{
	id: '3B336004-14FA-4123-94C3-DCF79F99B1E9',
	name: 'menuitem52',
	text: '表单值重置',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单值重置',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto106',
	resourcetag: '',
},
		{
	id: 'E42028FD-BE02-4BCF-9C91-0262CC6608CC',
	name: 'menuitem55',
	text: '动态显示',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态显示',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto155',
	resourcetag: '',
},
		{
	id: 'D89DD0B8-4556-4EC1-BAFA-263646932344',
	name: 'menuitem53',
	text: '动态启用',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态启用',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto151',
	resourcetag: '',
},
		{
	id: 'F22D5209-1AD0-4941-94EC-FCEC677EA531',
	name: 'menuitem54',
	text: '动态空输入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态空输入',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto81',
	resourcetag: '',
},
		{
	id: '895F9127-3C08-4FB3-B621-5DA85BC1E946',
	name: 'menuitem56',
	text: '表单项更新',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单项更新',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto114',
	resourcetag: '',
},
		{
	id: '24356FD6-4084-495B-81CC-19E45E228A43',
	name: 'menuitem108',
	text: '表单值规则',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单值规则',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc32',
	resourcetag: '',
},
	],
},
		{
	id: '90B5DE74-8BEB-4E9D-AB84-17B7FFDDF595',
	name: 'menuitem16',
	text: '搜索表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '搜索表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto173',
	resourcetag: '',
},
	],
},
		{
	id: '613BC68B-4710-4BBB-8D93-90D1EBD68357',
	name: 'menuitem157',
	text: '导航类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '导航类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '41B49C7B-AE54-4D45-A875-E67AA6E38D8D',
	name: 'menuitem120',
	text: '分页导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '分页导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc42',
	resourcetag: '',
},
		{
	id: 'CDCA8F20-7DEE-45F0-9506-2798280448E5',
	name: 'menuitem128',
	text: '表格导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc46',
	resourcetag: '',
},
		{
	id: '1D96C36E-1A21-4DC6-9DF6-F80EDC8479AE',
	name: 'menuitem114',
	text: '列表导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc56',
	resourcetag: '',
},
		{
	id: '1F7E6CB9-1594-4250-B968-33121E142765',
	name: 'menuitem137',
	text: '卡片导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '卡片导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc58',
	resourcetag: '',
},
		{
	id: '53BCF5CC-6EE4-4D7D-A197-9E88FE62965F',
	name: 'menuitem136',
	text: '树导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc57',
	resourcetag: '',
},
		{
	id: '8C86D2B0-537D-430C-B399-9DF595354E50',
	name: 'menuitem138',
	text: '日历导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc59',
	resourcetag: '',
},
		{
	id: '2EAF10FE-DA80-445A-BDA1-100F839C2AEC',
	name: 'menuitem139',
	text: '时间轴导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '时间轴导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc60',
	resourcetag: '',
},
		{
	id: '70E318E0-6C9B-48A2-87FB-7AD672B2828C',
	name: 'menuitem20',
	text: '数据关系分页',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'D3C24718-9CBA-44D2-BFE5-CEF0BF99E464',
	name: 'menuitem117',
	text: '数据关系分页（上下关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页（上下关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc41',
	resourcetag: '',
},
		{
	id: '2C23AC01-A913-45E3-8B34-899B75D7996F',
	name: 'menuitem118',
	text: '数据关系分页（分页关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据关系分页（分页关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto337',
	resourcetag: '',
},
	],
},
		{
	id: '31660637-4E9B-4AF0-B476-D1400C4D1AED',
	name: 'menuitem116',
	text: ' 数据关系栏',
	type: 'MENUITEM',
	counterid: '',
	tooltip: ' 数据关系栏',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto402',
	resourcetag: '',
},
	],
},
		{
	id: 'FFD37BBB-5AEB-440C-8F88-FCB51392B252',
	name: 'menuitem158',
	text: '面板类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '面板类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'FC7C7D72-0888-449D-80C0-B4314EB184E4',
	name: 'menuitem145',
	text: '选择视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '选择视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc64',
	resourcetag: '',
},
		{
	id: '58A0151D-4D23-4271-A1E0-DFCA451FA05B',
	name: 'menuitem17',
	text: '向导面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '向导面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'A434374A-1309-4A09-95C5-6E6189930519',
	name: 'menuitem134',
	text: '基础用法',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '基础用法',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc49',
	resourcetag: '',
},
		{
	id: '62C44534-1497-4974-8176-6438D3A5EDDE',
	name: 'menuitem135',
	text: '状态属性',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '状态属性',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc51',
	resourcetag: '',
},
	],
},
		{
	id: '0CECE101-0956-4DED-AE3F-4C402B8789A5',
	name: 'menuitem121',
	text: '多编辑视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多编辑视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '5C0545C7-243B-462A-AEF7-718AD5AE593D',
	name: 'menuitem115',
	text: '多表单（行记录）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多表单（行记录）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc36',
	resourcetag: '',
},
		{
	id: '0A353FD9-D5EB-4291-A867-EF3E9AE78DBD',
	name: 'menuitem123',
	text: '多表单（上分页）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多表单（上分页）',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc43',
	resourcetag: '',
},
	],
},
	],
},
		{
	id: '92FD55EA-B318-4828-AE4D-2BF9C89C5A4D',
	name: 'menuitem119',
	text: '多数据类',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多数据类',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'DD8F1A1F-8DEE-4153-9C5D-81EE0DD35003',
	name: 'menuitem13',
	text: '表格',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '8BDBC421-8781-4E1D-9729-77C9B751A539',
	name: 'menuitem57',
	text: '禁用排序',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '禁用排序',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto176',
	resourcetag: '',
},
		{
	id: '9CA2B662-1385-47FC-92D6-99F7BF6E6739',
	name: 'menuitem59',
	text: '行操作',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '行操作',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto286',
	resourcetag: '',
},
		{
	id: '8331CBD3-7523-4C9F-BAA0-8F3B7EED8ABB',
	name: 'menuitem58',
	text: '行编辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '行编辑',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto124',
	resourcetag: '',
},
		{
	id: 'FF850C68-E9AE-47CF-8491-6C785F99BCCD',
	name: 'menuitem73',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
},
		{
	id: '02D26612-7D77-4D2E-89C8-729D6C144615',
	name: 'menuitem74',
	text: '表格行编辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格行编辑',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc3',
	resourcetag: '',
},
		{
	id: '603BA5C1-8623-450E-AA83-FD73643F5462',
	name: 'menuitem75',
	text: '新建默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '新建默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc4',
	resourcetag: '',
},
		{
	id: '08BC7EDE-B113-4F54-8260-9F8D6C3C1387',
	name: 'menuitem76',
	text: '更新默认值',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更新默认值',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc5',
	resourcetag: '',
},
		{
	id: '1174F6B4-F52E-46A5-851A-6B6501B135B4',
	name: 'menuitem77',
	text: '表格值规则',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格值规则',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc6',
	resourcetag: '',
},
		{
	id: 'E63538F1-1145-4D99-A66E-1E76A6CFA0F9',
	name: 'menuitem132',
	text: '表格列更新',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格列更新',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc54',
	resourcetag: '',
},
		{
	id: '698ED1B9-E0DC-49E5-A852-E4DFC07FEB56',
	name: 'menuitem133',
	text: '表格列重置',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格列重置',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc55',
	resourcetag: '',
},
		{
	id: '9D782B9A-CD40-4C71-87D8-01FA6EE451D3',
	name: 'menuitem78',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc7',
	resourcetag: '',
},
		{
	id: '9C0FD420-1E91-4AA3-80C9-00E76EA0C13D',
	name: 'menuitem80',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc8',
	resourcetag: '',
},
		{
	id: '0F6EED8B-C775-4224-9B12-BBC881A9881B',
	name: 'menuitem81',
	text: '当前页聚合',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '当前页聚合',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc9',
	resourcetag: '',
},
		{
	id: '6342223C-6C73-431F-97AE-CD0DEFB34F28',
	name: 'menuitem82',
	text: '远程聚合',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '远程聚合',
	expanded: false,
	separator: false,
	hidden: true,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc10',
	resourcetag: '',
},
	],
},
		{
	id: 'C39C5CF4-3B70-4686-B5B8-B2CE8B70BA17',
	name: 'menuitem83',
	text: '列表',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '8054A84C-4D9A-4523-A533-96B1914514C3',
	name: 'menuitem84',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc11',
	resourcetag: '',
},
		{
	id: '0A1EBBD7-8284-4882-AC2A-66BFBF3FBC9E',
	name: 'menuitem85',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc12',
	resourcetag: '',
},
		{
	id: '3C545997-D347-4AF5-826F-A43B90CE2272',
	name: 'menuitem86',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc13',
	resourcetag: '',
},
		{
	id: 'EFE4F84D-0F03-4FFF-9F31-BB4B39861289',
	name: 'menuitem91',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc17',
	resourcetag: '',
},
		{
	id: 'E52F3005-B981-4244-92F3-F612A2DA68DE',
	name: 'menuitem143',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc65',
	resourcetag: '',
},
	],
},
		{
	id: '32143425-F549-4308-BC7C-881ED8590083',
	name: 'menuitem95',
	text: '日历',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '450BE44D-D77D-4F0D-823E-5D019A8DE337',
	name: 'menuitem96',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc20',
	resourcetag: '',
},
		{
	id: '0FF46343-77B2-4F8A-B02C-CBDE670102CC',
	name: 'menuitem97',
	text: '时间轴样式',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '时间轴样式',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc21',
	resourcetag: '',
},
		{
	id: '68F65318-C0E8-4AE0-BA3E-05B972D80CBB',
	name: 'menuitem109',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc29',
	resourcetag: '',
},
		{
	id: '71791ADF-5EFE-4A9F-A1D2-5ABFC9D7DACA',
	name: 'menuitem64',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc72',
	resourcetag: '',
},
	],
},
		{
	id: '3C1EE548-480B-423D-AC9E-D308135F4715',
	name: 'menuitem14',
	text: '树视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'B2CD45CC-E04F-4A2B-B847-202AF00BB378',
	name: 'menuitem60',
	text: '静态节点',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '静态节点',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto375',
	resourcetag: '',
},
		{
	id: '0EDAD6CA-4C13-4DB8-951E-7421ACCBB061',
	name: 'menuitem61',
	text: '动态节点（代码表）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态节点（代码表）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto66',
	resourcetag: '',
},
		{
	id: 'BF566D0F-7E25-4641-B8C0-D9D76437FB28',
	name: 'menuitem62',
	text: '动态节点（实体）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '动态节点（实体）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto96',
	resourcetag: '',
},
		{
	id: 'C2E07EB8-2D27-4075-B7BB-E59764D1CA54',
	name: 'menuitem63',
	text: '右键操作',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '右键操作',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto235',
	resourcetag: '',
},
	],
},
		{
	id: '93E8A13E-FE91-437A-96E7-8AEF9D225F58',
	name: 'menuitem111',
	text: '甘特图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '甘特图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc74',
	resourcetag: '',
},
		{
	id: 'D85540A9-6998-45CE-82C2-A94284961E8B',
	name: 'menuitem110',
	text: '树表格',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树表格',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc73',
	resourcetag: '',
},
		{
	id: '71AE4A1F-9D56-42D2-9E62-97106284E964',
	name: 'menuitem87',
	text: '数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '4ACE3BC7-1911-4513-8435-75C18C9A5A6F',
	name: 'menuitem88',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc14',
	resourcetag: '',
},
		{
	id: '3F2DF58D-0921-4A0D-B450-616F69DAB6DB',
	name: 'menuitem89',
	text: '自动分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自动分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc15',
	resourcetag: '',
},
		{
	id: 'AA2F6169-D1B2-4966-B187-DE06F8ECEB75',
	name: 'menuitem90',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc16',
	resourcetag: '',
},
		{
	id: '6984FCBE-7110-4938-91D4-63188A2C7C23',
	name: 'menuitem94',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc19',
	resourcetag: '',
},
		{
	id: 'A755CC52-5099-445A-B885-23ECEDF394CA',
	name: 'menuitem152',
	text: '自定义插件',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义插件',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc71',
	resourcetag: '',
},
	],
},
		{
	id: '41DDB50F-B15B-4E75-9FD3-D7C409EBB6E5',
	name: 'menuitem101',
	text: '看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'F824F43E-E3D9-4F1C-8008-43974B9726EA',
	name: 'menuitem102',
	text: '内置功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '内置功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc25',
	resourcetag: '',
},
		{
	id: '0BF8FF1D-A175-4398-A737-996403A0D4F9',
	name: 'menuitem104',
	text: '代码表分组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '代码表分组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc26',
	resourcetag: '',
},
		{
	id: '4DA1C300-B9F7-43D0-B4EF-ED86B1A22576',
	name: 'menuitem105',
	text: '项布局面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '项布局面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc27',
	resourcetag: '',
},
	],
},
		{
	id: '84FFF868-FAE3-41C3-9C0C-6D2B2130EA9D',
	name: 'menuitem37',
	text: '数据图表',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据图表',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'A6A3F8BC-F8F0-44AB-9D45-E45A65BCF70B',
	name: 'menuitem38',
	text: '柱状图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '柱状图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto25',
	resourcetag: '',
},
		{
	id: '52EFE36A-0249-4B6C-AEA0-444B910ED60D',
	name: 'menuitem39',
	text: '折线图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '折线图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto387',
	resourcetag: '',
},
		{
	id: 'BA5C5A29-E660-4DC2-8D0D-7FE9872474DB',
	name: 'menuitem40',
	text: '饼图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '饼图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto320',
	resourcetag: '',
},
		{
	id: 'E3FD69CF-59C4-4342-ABE0-7315361017C5',
	name: 'menuitem41',
	text: '区域图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '区域图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto3',
	resourcetag: '',
},
		{
	id: '8B247E6B-79A4-4197-8E2C-E8A35C98DED0',
	name: 'menuitem42',
	text: '雷达图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '雷达图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto2',
	resourcetag: '',
},
	],
},
	],
},
	],
},
            {
	id: '093B798E-B4A5-4AE4-A75C-9F8E4507ADF7',
	name: 'menuitem5',
	text: '视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-file-photo-o',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '591E33C7-2371-452B-A9E8-009889AA3242',
	name: 'menuitem140',
	text: '单数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '单数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'E63BAEAA-6E59-49FA-9BAF-C994F3DCBE04',
	name: 'menuitem161',
	text: '实体向导视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体向导视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc49',
	resourcetag: '',
},
		{
	id: 'FC358495-A6D5-4999-8EBF-FDE22C37CDDF',
	name: 'menuitem8',
	text: '实体编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc31',
	resourcetag: '',
},
		{
	id: '8A6BAC27-F4F7-45DA-BBED-81B87A2644D9',
	name: 'menuitem162',
	text: '实体编辑视图（分页关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（分页关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto337',
	resourcetag: '',
},
		{
	id: '0EE588FF-CFF4-4927-87D5-7B551289B185',
	name: 'menuitem163',
	text: '实体编辑视图（上下关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（上下关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc41',
	resourcetag: '',
},
		{
	id: '061B6625-C5FF-4CFC-B29B-966F67418F93',
	name: 'menuitem164',
	text: '实体编辑视图（左右关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体编辑视图（左右关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto402',
	resourcetag: '',
},
		{
	id: '857F4FAB-B583-4B34-9A8B-AAF4DC90E735',
	name: 'menuitem165',
	text: '实体分页导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体分页导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto213',
	resourcetag: '',
},
		{
	id: '2A7A3563-E426-4050-9C6A-5203452B746E',
	name: 'menuitem166',
	text: '实体数据看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体数据看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc45',
	resourcetag: '',
},
		{
	id: '3D865DF2-CB8C-48F8-9525-151F88BECF1E',
	name: 'menuitem167',
	text: '实体选项操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体选项操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc48',
	resourcetag: '',
},
	],
},
		{
	id: '8A92122D-7984-4A26-95C6-674F7418CD4D',
	name: 'menuitem141',
	text: '多数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '多数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'A4D0FFB8-006A-4569-8954-383DD9A3DC4D',
	name: 'menuitem79',
	text: '实体表格视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体表格视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto299',
	resourcetag: '',
},
		{
	id: 'D34762D3-4332-4DB3-BD15-58E4D6CB527A',
	name: 'menuitem168',
	text: '实体多表单编辑视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体多表单编辑视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc43',
	resourcetag: '',
},
		{
	id: '3E560E08-4C06-4FFA-8147-A5730D68377B',
	name: 'menuitem169',
	text: '实体甘特视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体甘特视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc74',
	resourcetag: '',
},
		{
	id: '881C85EB-18F6-4CE9-9502-D5C722CCBF1C',
	name: 'menuitem9',
	text: '实体列表视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc90',
	resourcetag: '',
},
		{
	id: '56F05C94-563D-4D81-8B9D-67B4403162AE',
	name: 'menuitem170',
	text: '实体日历视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体日历视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc20',
	resourcetag: '',
},
		{
	id: '20C70548-B72A-45B9-A81E-3AE14DF80921',
	name: 'menuitem171',
	text: '实体看板视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体看板视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc25',
	resourcetag: '',
},
		{
	id: '3F27A48A-AF26-494C-A8DA-54C61BEB6AB8',
	name: 'menuitem172',
	text: '实体树表格视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树表格视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc73',
	resourcetag: '',
},
		{
	id: '99E7BFD9-D57A-4C87-A6EB-B877E8F7CA83',
	name: 'menuitem173',
	text: '实体树视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc91',
	resourcetag: '',
},
		{
	id: 'A12848F0-F4E6-42C5-8E80-B60AA085FA9C',
	name: 'menuitem174',
	text: '实体数据视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体数据视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc14',
	resourcetag: '',
},
		{
	id: 'B7B3BD4E-E90B-4C1F-9842-5637A4307A83',
	name: 'menuitem175',
	text: '实体图表视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体图表视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc35',
	resourcetag: '',
},
	],
},
		{
	id: 'B57A15EB-898E-4C37-A8BD-6EF17A575114',
	name: 'menuitem10',
	text: '导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '2EEB2229-9A34-40F2-9C9E-376F3EFE022A',
	name: 'menuitem176',
	text: '实体表格导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体表格导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc46',
	resourcetag: '',
},
		{
	id: '024176EE-CDF9-4DB2-AB0F-E8FD7B68D63E',
	name: 'menuitem177',
	text: '实体列表导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体列表导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc56',
	resourcetag: '',
},
		{
	id: '8C4FBB02-8CE5-414B-99E8-CDFE3D50FC7E',
	name: 'menuitem178',
	text: '实体卡片导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体卡片导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc58',
	resourcetag: '',
},
		{
	id: 'D7E81FF2-64AB-4F3A-BD1B-3C96672E6D4D',
	name: 'menuitem179',
	text: '实体日历导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体日历导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc59',
	resourcetag: '',
},
		{
	id: 'D2DBAE8C-4D1B-4A44-AB1F-7D08064581E9',
	name: 'menuitem180',
	text: '实体树导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '实体树导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc57',
	resourcetag: '',
},
	],
},
		{
	id: '3889B9E3-5F86-45A6-97DB-F6788D1A0A30',
	name: 'menuitem26',
	text: '选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '3430B73F-EF8C-44D1-B5B8-ACD6837AEC55',
	name: 'menuitem18',
	text: '数据选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc64',
	resourcetag: '',
},
		{
	id: '42418BDB-EBFE-4620-829A-F43F906D10F6',
	name: 'menuitem27',
	text: '索引选择视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '索引选择视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto296',
	resourcetag: '',
},
	],
},
		{
	id: '9FBE2904-9E5D-4377-8E9C-85B3B7DBCF55',
	name: 'menuitem69',
	text: '工作流',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc85',
	resourcetag: '',
	items: [
		{
	id: '58CAE988-3129-485E-B230-1A2F240FEE60',
	name: 'menuitem30',
	text: '工作流动态导航视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态导航视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc85',
	resourcetag: '',
},
		{
	id: 'DB637A67-5B4F-4EE3-A17D-86B8B6F795F9',
	name: 'menuitem31',
	text: '工作流启动',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流启动',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc86',
	resourcetag: '',
},
		{
	id: 'C9E06A12-760D-480C-9157-8769239D8A81',
	name: 'menuitem21',
	text: '工作流动态操作视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '工作流动态操作视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc94',
	resourcetag: '',
},
	],
},
		{
	id: '0DCD7D59-BE26-440E-A12B-F5E7CE5B6BF1',
	name: 'menuitem11',
	text: '其他视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '其他视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '547D1914-9532-4F90-8029-C6B172B58F84',
	name: 'menuitem98',
	text: '自定义视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc22',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: 'F7BAF026-7BD6-4E81-92BC-7684D4F449C8',
	name: 'menuitem153',
	text: '逻辑',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '逻辑',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-skyatlas',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '8DA40B71-B47B-4373-B3CB-53C7E1573466',
	name: 'menuitem154',
	text: '应用功能',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '应用功能',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '2CFDFC3B-D5CB-465B-B0A9-101AE7E564AA',
	name: 'menuitem127',
	text: '打开应用视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '打开应用视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc2',
	resourcetag: '',
},
		{
	id: '07F7227E-0AC1-42E3-B5E5-24A4258E3676',
	name: 'menuitem147',
	text: '打开HTML页面',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '打开HTML页面',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc75',
	resourcetag: '',
},
		{
	id: 'F6BC48CE-3D30-403C-A1C6-CC9A626ACBBF',
	name: 'menuitem160',
	text: '执行JavaScript',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '执行JavaScript',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc78',
	resourcetag: '',
},
	],
},
		{
	id: '09E7AD32-23A5-4237-A074-327EB570DEB3',
	name: 'menuitem155',
	text: '界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'FCE318CB-67D4-43B2-AF43-A4059B7EB00B',
	name: 'menuitem181',
	text: '前台界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '前台界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto67',
	resourcetag: '',
},
		{
	id: '28A7B5D6-7C29-4A63-B045-33EC4726756A',
	name: 'menuitem182',
	text: '后台界面行为',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '后台界面行为',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto39',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: 'FDF5C150-9BE5-4690-A177-93CE10C298F9',
	name: 'menuitem2',
	text: '更多',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '更多',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: 'fa fa-yelp',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'E606D7BB-FFBE-41EA-B365-2B9BFE40F2A2',
	name: 'menuitem19',
	text: '临时模式',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '临时模式',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc95',
	resourcetag: '',
},
		{
	id: 'E9D4989A-6A7D-449D-896F-72130497B12F',
	name: 'menuitem46',
	text: '数据导出导入',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据导出导入',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc88',
	resourcetag: '',
},
		{
	id: '09508535-105F-4AE4-9137-02205BF2B4A9',
	name: 'menuitem67',
	text: '索引实体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '索引实体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto296',
	resourcetag: '',
},
		{
	id: 'A2F41406-B571-4B62-B2DC-62FDB903D04B',
	name: 'menuitem184',
	text: '主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '9F6BCBE0-875A-4552-B7FE-9E09E7FE270C',
	name: 'menuitem70',
	text: '表格主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc79',
	resourcetag: '',
},
		{
	id: 'C6752933-CC62-4EE1-88D8-1926F1F84DFE',
	name: 'menuitem148',
	text: '列表主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc80',
	resourcetag: '',
},
		{
	id: '9ACF9757-E814-4F47-9489-7E6BA01830FC',
	name: 'menuitem183',
	text: '数据主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '数据主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc81',
	resourcetag: '',
},
		{
	id: '54268E74-FC92-4B5F-BA26-92EEA43C42F2',
	name: 'menuitem28',
	text: '日历主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '日历主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc83',
	resourcetag: '',
},
		{
	id: 'A120A397-415F-4877-862A-7D626F0EE901',
	name: 'menuitem29',
	text: '树主状态',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '树主状态',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc84',
	resourcetag: '',
},
	],
},
	],
},
            {
	id: '366FB94A-4C7C-4836-A45E-FF9AB2551DFF',
	name: 'menuitem22',
	text: '测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: 'DD647DD5-C762-428E-B494-8B1AA72365B4',
	name: 'menuitem23',
	text: '卡片导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '卡片导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc96',
	resourcetag: '',
},
		{
	id: 'EFF9802D-8228-4F0B-9D3C-FD47CA690AAB',
	name: 'menuitem24',
	text: '表单嵌入卡片视图',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表单嵌入卡片视图',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc97',
	resourcetag: '',
},
		{
	id: '7BCBA66C-E9A9-4A00-8BF4-7C6DDF7EDA73',
	name: 'menuitem25',
	text: '关系界面刷新主表单',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '关系界面刷新主表单',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc98',
	resourcetag: '',
},
	],
},
            {
	id: '4B9CCFCE-B2E2-4BF7-A5F4-011A4E054F0E',
	name: 'menuitem66',
	text: '视图布局面板测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '视图布局面板测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '',
	resourcetag: '',
	items: [
		{
	id: '78F321F3-3FE2-4D1D-95F2-AC0DBCE5A846',
	name: 'menuitem122',
	text: '表格视图面板',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '表格视图面板',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc99',
	resourcetag: '',
},
		{
	id: 'E37F3FD8-ED61-4D3C-8640-75F2DCAE55D2',
	name: 'menuitem125',
	text: '测试表单自定义布局多媒体',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '测试表单自定义布局多媒体',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc100',
	resourcetag: '',
},
		{
	id: 'F8CAA54B-0B92-48D6-8C89-F8D65B84520E',
	name: 'menuitem126',
	text: '自定义导航',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '自定义导航',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1102681676',
	resourcetag: '',
},
		{
	id: 'E9C3B5E0-F8C3-4E27-8FCD-92F323A957BA',
	name: 'menuitem130',
	text: '布局面板组件测试',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '布局面板组件测试',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'AppFunc101',
	resourcetag: '',
},
		{
	id: '552D9B6A-0B17-45A2-A827-FAB8173098A6',
	name: 'menuitem131',
	text: '编辑视图（左右关系）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '编辑视图（左右关系）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103768001',
	resourcetag: '',
},
		{
	id: '0EBD0EEA-C331-488D-8510-8D1E65C8D175',
	name: 'menuitem142',
	text: '列表视图（自定义面板）',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '列表视图（自定义面板）',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'UsrAppFunc1103202475',
	resourcetag: '',
},
	],
},
        ],
    }];
});

