package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0021;
/**
 * 关系型数据实体[IBIZSample0021] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单")
public class IBIZSample0021SearchContext extends QueryWrapperContext<IBIZSample0021> {

    @JsonProperty("n_ibizsample0021id_eq")
    @JSONField(name = "n_ibizsample0021id_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizSample0021IdEQ;
	public IBIZSample0021SearchContext setIbizSample0021IdEQ(String ibizSample0021IdEQ) {
        this.ibizSample0021IdEQ = ibizSample0021IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0021IdEQ)){
            this.getSearchCond().eq("ibizsample0021id", ibizSample0021IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0021name_like")
    @JSONField(name = "n_ibizsample0021name_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizSample0021NameLIKE;
	public IBIZSample0021SearchContext setIbizSample0021NameLIKE(String ibizSample0021NameLIKE) {
        this.ibizSample0021NameLIKE = ibizSample0021NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0021NameLIKE)){
            this.getSearchCond().like("ibizsample0021name", ibizSample0021NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_orderstate_eq")
    @JSONField(name = "n_orderstate_eq")
    @ApiModelProperty("订单状态EQ")
	private String orderStateEQ;
	public IBIZSample0021SearchContext setOrderStateEQ(String orderStateEQ) {
        this.orderStateEQ = orderStateEQ;
        if(!ObjectUtils.isEmpty(this.orderStateEQ)){
            this.getSearchCond().eq("orderstate", orderStateEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0021name", query)
            );
		}
	}
}