package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSample0011;
import cn.ibizlab.core.sample.filter.IBIZSample0011SearchContext;
import cn.ibizlab.core.sample.domain.IBIZSample0010;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

public interface IBIZSample0011Service extends IService<IBIZSample0011> {

    default IBIZSample0011Service getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSample0011 get(IBIZSample0011 et);
    default IBIZSample0011 get(String key) {
        IBIZSample0011 et = new IBIZSample0011();
        et.setIbizSample0011Id(key);
        return getSelf().get(et);
    }
    default List<IBIZSample0011> getByIds(Collection<String> ids) {
        List<IBIZSample0011> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0011 et = new IBIZSample0011();
            et.setIbizSample0011Id(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSample0011> getByEntities(List<IBIZSample0011> entities);

    IBIZSample0011 getDraft(IBIZSample0011 et);

    Integer checkKey(IBIZSample0011 et);

    boolean create(IBIZSample0011 et);
    boolean createBatch(List<IBIZSample0011> list);

    boolean update(IBIZSample0011 et);
    boolean updateBatch(List<IBIZSample0011> list);

    boolean save(IBIZSample0011 et);
    boolean saveBatch(List<IBIZSample0011> list);

    default boolean remove(String key) {
        IBIZSample0011 et = new IBIZSample0011();
        et.setIbizSample0011Id(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSample0011 et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSample0011> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSample0011 et = new IBIZSample0011();
            et.setIbizSample0011Id(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSample0011> entities);

    Page<IBIZSample0011> searchDefault(IBIZSample0011SearchContext context);
    List<IBIZSample0011> listDefault(IBIZSample0011SearchContext context);

    List<IBIZSample0011> selectByIbizSample0010Id(String ibizSample0010Id);
    boolean removeByIbizSample0010Id(String ibizSample0010Id);
    boolean resetByIbizSample0010Id(String ibizSample0010Id);
    boolean saveByIbizsample0010(cn.ibizlab.core.sample.domain.IBIZSample0010 ibizSample0010,List<IBIZSample0011> list);
    default boolean saveByIbizSample0010Id(String ibizSample0010Id,List<IBIZSample0011> list) {
        cn.ibizlab.core.sample.domain.IBIZSample0010 et = new cn.ibizlab.core.sample.domain.IBIZSample0010();
        et.setIbizSample0010Id(ibizSample0010Id);
        return getSelf().saveByIbizsample0010(et,list);
    }

    List<IBIZSample0011> selectByIbizuniProductId(String ibizuniProductId);
    boolean removeByIbizuniProductId(String ibizuniProductId);
    boolean resetByIbizuniProductId(String ibizuniProductId);
    boolean saveByIbizuniproduct(cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniProduct,List<IBIZSample0011> list);
    default boolean saveByIbizuniProductId(String ibizuniProductId,List<IBIZSample0011> list) {
        cn.ibizlab.core.sample.domain.IBIZUNIProduct et = new cn.ibizlab.core.sample.domain.IBIZUNIProduct();
        et.setIbizuniProductId(ibizuniProductId);
        return getSelf().saveByIbizuniproduct(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}