package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0015;
/**
 * 关系型数据实体[IBIZSample0015] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("项目")
public class IBIZSample0015SearchContext extends QueryWrapperContext<IBIZSample0015> {

    @JsonProperty("n_ibizsample0015name_like")
    @JSONField(name = "n_ibizsample0015name_like")
    @ApiModelProperty("项目名称LIKE")
	private String ibizSample0015NameLIKE;
	public IBIZSample0015SearchContext setIbizSample0015NameLIKE(String ibizSample0015NameLIKE) {
        this.ibizSample0015NameLIKE = ibizSample0015NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0015NameLIKE)){
            this.getSearchCond().like("ibizsample0015name", ibizSample0015NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0015id_eq")
    @JSONField(name = "n_ibizsample0015id_eq")
    @ApiModelProperty("项目标识EQ")
	private String ibizSample0015IdEQ;
	public IBIZSample0015SearchContext setIbizSample0015IdEQ(String ibizSample0015IdEQ) {
        this.ibizSample0015IdEQ = ibizSample0015IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0015IdEQ)){
            this.getSearchCond().eq("ibizsample0015id", ibizSample0015IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0015name", query)
            );
		}
	}
}