package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZCPU;
import cn.ibizlab.core.sample.filter.IBIZCPUSearchContext;
import cn.ibizlab.core.sample.domain.IBIZHardware;

public interface IBIZCPUService extends IService<IBIZCPU> {

    default IBIZCPUService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZCPU get(IBIZCPU et);
    default IBIZCPU get(String key) {
        IBIZCPU et = new IBIZCPU();
        et.setIbizcpuid(key);
        return getSelf().get(et);
    }
    default List<IBIZCPU> getByIds(Collection<String> ids) {
        List<IBIZCPU> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCPU et = new IBIZCPU();
            et.setIbizcpuid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZCPU> getByEntities(List<IBIZCPU> entities);

    IBIZCPU getDraft(IBIZCPU et);

    Integer checkKey(IBIZCPU et);

    boolean create(IBIZCPU et);
    boolean createBatch(List<IBIZCPU> list);

    boolean update(IBIZCPU et);
    boolean updateBatch(List<IBIZCPU> list);

    boolean save(IBIZCPU et);
    boolean saveBatch(List<IBIZCPU> list);

    default boolean remove(String key) {
        IBIZCPU et = new IBIZCPU();
        et.setIbizcpuid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZCPU et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZCPU> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCPU et = new IBIZCPU();
            et.setIbizcpuid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZCPU> entities);

    Page<IBIZCPU> searchDefault(IBIZCPUSearchContext context);
    List<IBIZCPU> listDefault(IBIZCPUSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}