package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
import cn.ibizlab.core.sample.service.IBIZSample0014Service;
import cn.ibizlab.core.sample.filter.IBIZSample0014SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"员工" })
@RestController("demoapi-ibizsample0014")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0014Resource {

    @Autowired
    public IBIZSample0014Service ibizSample0014Service;

    @Autowired
    @Lazy
    public IBIZSample0014DTOMapping ibizSample0014DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"员工" },  notes = "IBIZSample0014-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-Create-all') or hasPermission(this.ibizSample0014DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0014-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s")
    public ResponseEntity<IBIZSample0014DTO> create
            (@Validated @RequestBody IBIZSample0014DTO dto) {
        IBIZSample0014 domain = ibizSample0014DtoMapping.toDomain(dto);
        ibizSample0014Service.create(domain);
        IBIZSample0014 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0014DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"员工" },  notes = "IBIZSample0014-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-Get-all') or hasPermission(this.ibizSample0014DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0014-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0014s/{ibizSample0014Id}")
    public ResponseEntity<IBIZSample0014DTO> getByIbizSample0014Id
            (@PathVariable("ibizSample0014Id") String ibizSample0014Id) {
        IBIZSample0014 rt = ibizSample0014Service.get(ibizSample0014Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0014DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"员工" },  notes = "IBIZSample0014-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-Remove-all') or hasPermission(this.ibizSample0014Service.get(#ibizSample0014Id),'DemoSys-IBIZSample0014-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0014s/{ibizSample0014Id}")
    public ResponseEntity<Boolean> removeByIbizSample0014Id
            (@PathVariable("ibizSample0014Id") String ibizSample0014Id) {
        Boolean rt = ibizSample0014Service.remove(ibizSample0014Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"员工" },  notes = "IBIZSample0014-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-Update-all') or hasPermission(this.ibizSample0014Service.get(#ibizSample0014Id),'DemoSys-IBIZSample0014-Update')")
    @VersionCheck(entity = "ibizsample0014" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0014s/{ibizSample0014Id}")
    public ResponseEntity<IBIZSample0014DTO> updateByIbizSample0014Id
            (@PathVariable("ibizSample0014Id") String ibizSample0014Id, @Validated @RequestBody IBIZSample0014DTO dto) {
        IBIZSample0014 domain = ibizSample0014DtoMapping.toDomain(dto);
        domain.setIbizSample0014Id(ibizSample0014Id);
        ibizSample0014Service.update(domain);
        IBIZSample0014 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0014DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"员工" },  notes = "IBIZSample0014-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0014DTO dto) {
        IBIZSample0014 domain = ibizSample0014DtoMapping.toDomain(dto);
        Integer rt = ibizSample0014Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"员工" },  notes = "IBIZSample0014-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0014s/getdraft")
    public ResponseEntity<IBIZSample0014DTO> getDraft
            (IBIZSample0014DTO dto) {
        IBIZSample0014 domain = ibizSample0014DtoMapping.toDomain(dto);
        IBIZSample0014 rt = ibizSample0014Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0014DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"员工" },  notes = "IBIZSample0014-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-Save-all') or hasPermission(this.ibizSample0014DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0014-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s/save")
    public ResponseEntity<IBIZSample0014DTO> save
            (@Validated @RequestBody IBIZSample0014DTO dto) {
        IBIZSample0014 domain = ibizSample0014DtoMapping.toDomain(dto);
        ibizSample0014Service.save(domain);
        IBIZSample0014 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0014DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCurIBIZSample0014", tags = {"员工" },  notes = "IBIZSample0014-FetchCurIBIZSample0014")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchCurIBIZSample0014-all','DemoSys-IBIZSample0014-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0014-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0014s/fetchcuribizsample0014")
    public ResponseEntity<List<IBIZSample0014DTO>> fetchCurIbizSample0014
            (IBIZSample0014SearchContext dto) {
        Page<IBIZSample0014> domains = ibizSample0014Service.searchCurIbizSample0014(dto) ;
        List<IBIZSample0014DTO> list = ibizSample0014DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"员工" },  notes = "IBIZSample0014-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0014-searchDefault-all','DemoSys-IBIZSample0014-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0014-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0014s/fetchdefault")
    public ResponseEntity<List<IBIZSample0014DTO>> fetchDefault
            (IBIZSample0014SearchContext dto) {
        Page<IBIZSample0014> domains = ibizSample0014Service.searchDefault(dto) ;
        List<IBIZSample0014DTO> list = ibizSample0014DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0014-Create-all')")
    @ApiOperation(value = "批量新建员工", tags = {"员工" },  notes = "批量新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0014DTO> dtos) {
        ibizSample0014Service.createBatch(ibizSample0014DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0014-Update-all')")
    @ApiOperation(value = "批量更新员工", tags = {"员工" },  notes = "批量更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0014s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0014DTO> dtos) {
        ibizSample0014Service.updateBatch(ibizSample0014DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0014-Save-all')")
    @ApiOperation(value = "批量保存员工", tags = {"员工" },  notes = "批量保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0014DTO> dtos) {
        ibizSample0014Service.saveBatch(ibizSample0014DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0014-Save-all')")
    @ApiOperation(value = "批量导入员工", tags = {"员工" },  notes = "批量导入员工")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0014s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0014DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0014> list=ibizSample0014DtoMapping.toDomain(dtos);
            List<IBIZSample0014> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0014Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0014-Remove-all')")
    @ApiOperation(value = "批量删除员工", tags = {"员工" },  notes = "批量删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0014s","/ibizsample0014s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0014Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
