package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.service.IBIZOrderTypeService;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单类型" })
@RestController("demoapi-ibizordertype")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZOrderTypeResource {

    @Autowired
    public IBIZOrderTypeService ibizOrderTypeService;

    @Autowired
    @Lazy
    public IBIZOrderTypeDTOMapping ibizOrderTypeDtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单类型" },  notes = "IBIZOrderType-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-Create-all') or hasPermission(this.ibizOrderTypeDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderType-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizordertypes")
    public ResponseEntity<IBIZOrderTypeDTO> create
            (@Validated @RequestBody IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        ibizOrderTypeService.create(domain);
        IBIZOrderType rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单类型" },  notes = "IBIZOrderType-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-Get-all') or hasPermission(this.ibizOrderTypeDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderType-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizordertypes/{ibizOrderTypeId}")
    public ResponseEntity<IBIZOrderTypeDTO> getByIbizOrderTypeId
            (@PathVariable("ibizOrderTypeId") String ibizOrderTypeId) {
        IBIZOrderType rt = ibizOrderTypeService.get(ibizOrderTypeId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单类型" },  notes = "IBIZOrderType-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-Remove-all') or hasPermission(this.ibizOrderTypeService.get(#ibizOrderTypeId),'DemoSys-IBIZOrderType-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizordertypes/{ibizOrderTypeId}")
    public ResponseEntity<Boolean> removeByIbizOrderTypeId
            (@PathVariable("ibizOrderTypeId") String ibizOrderTypeId) {
        Boolean rt = ibizOrderTypeService.remove(ibizOrderTypeId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单类型" },  notes = "IBIZOrderType-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-Update-all') or hasPermission(this.ibizOrderTypeService.get(#ibizOrderTypeId),'DemoSys-IBIZOrderType-Update')")
    @VersionCheck(entity = "ibizordertype" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizordertypes/{ibizOrderTypeId}")
    public ResponseEntity<IBIZOrderTypeDTO> updateByIbizOrderTypeId
            (@PathVariable("ibizOrderTypeId") String ibizOrderTypeId, @Validated @RequestBody IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        domain.setIbizOrderTypeId(ibizOrderTypeId);
        ibizOrderTypeService.update(domain);
        IBIZOrderType rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单类型" },  notes = "IBIZOrderType-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        Integer rt = ibizOrderTypeService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单类型" },  notes = "IBIZOrderType-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizordertypes/getdraft")
    public ResponseEntity<IBIZOrderTypeDTO> getDraft
            (IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        IBIZOrderType rt = ibizOrderTypeService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "ResetCodeList", tags = {"订单类型" },  notes = "IBIZOrderType-ResetCodeList")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-ResetCodeList-all') or hasPermission(this.ibizOrderTypeDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderType-ResetCodeList')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/{ibizOrderTypeId}/resetcodelist")
    public ResponseEntity<IBIZOrderTypeDTO> resetCodeListByIbizOrderTypeId
            (@PathVariable("ibizOrderTypeId") String ibizOrderTypeId, @Validated @RequestBody IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        domain.setIbizOrderTypeId(ibizOrderTypeId);
        IBIZOrderType rt = ibizOrderTypeService.resetCodeList(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单类型" },  notes = "IBIZOrderType-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-Save-all') or hasPermission(this.ibizOrderTypeDtoMapping.toDomain(#dto),'DemoSys-IBIZOrderType-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/save")
    public ResponseEntity<IBIZOrderTypeDTO> save
            (@Validated @RequestBody IBIZOrderTypeDTO dto) {
        IBIZOrderType domain = ibizOrderTypeDtoMapping.toDomain(dto);
        ibizOrderTypeService.save(domain);
        IBIZOrderType rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderTypeDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单类型" },  notes = "IBIZOrderType-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-searchDefault-all','DemoSys-IBIZOrderType-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrderType-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizordertypes/fetchdefault")
    public ResponseEntity<List<IBIZOrderTypeDTO>> fetchDefault
            (IBIZOrderTypeSearchContext dto) {
        Page<IBIZOrderType> domains = ibizOrderTypeService.searchDefault(dto) ;
        List<IBIZOrderTypeDTO> list = ibizOrderTypeDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderType-Create-all')")
    @ApiOperation(value = "批量新建订单类型", tags = {"订单类型" },  notes = "批量新建订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderTypeDTO> dtos) {
        ibizOrderTypeService.createBatch(ibizOrderTypeDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderType-Update-all')")
    @ApiOperation(value = "批量更新订单类型", tags = {"订单类型" },  notes = "批量更新订单类型")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizordertypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderTypeDTO> dtos) {
        ibizOrderTypeService.updateBatch(ibizOrderTypeDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderType-Save-all')")
    @ApiOperation(value = "批量保存订单类型", tags = {"订单类型" },  notes = "批量保存订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderTypeDTO> dtos) {
        ibizOrderTypeService.saveBatch(ibizOrderTypeDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderType-Save-all')")
    @ApiOperation(value = "批量导入订单类型", tags = {"订单类型" },  notes = "批量导入订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "ibizordertypes/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZOrderTypeDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZOrderType> list=ibizOrderTypeDtoMapping.toDomain(dtos);
            List<IBIZOrderType> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizOrderTypeService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrderType-Remove-all')")
    @ApiOperation(value = "批量删除订单类型", tags = {"订单类型" },  notes = "批量删除订单类型")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizordertypes","/ibizordertypes/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizOrderTypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
