package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrder;
import cn.ibizlab.core.sample.service.IBIZOrderService;
import cn.ibizlab.core.sample.filter.IBIZOrderSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("demoapi-ibizorder")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZOrderResource {

    @Autowired
    public IBIZOrderService ibizOrderService;

    @Autowired
    @Lazy
    public IBIZOrderDTOMapping ibizOrderDtoMapping;


    @ApiOperation(value = "创建Create", tags = {"订单" },  notes = "IBIZOrder-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-Create-all') or hasPermission(this.ibizOrderDtoMapping.toDomain(#dto),'DemoSys-IBIZOrder-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders")
    public ResponseEntity<IBIZOrderDTO> create
            (@Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        ibizOrderService.create(domain);
        IBIZOrder rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"订单" },  notes = "IBIZOrder-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-Get-all') or hasPermission(this.ibizOrderDtoMapping.toDomain(returnObject.body),'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/{ibizOrderId}")
    public ResponseEntity<IBIZOrderDTO> getByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId) {
        IBIZOrder rt = ibizOrderService.get(ibizOrderId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"订单" },  notes = "IBIZOrder-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-Remove-all') or hasPermission(this.ibizOrderService.get(#ibizOrderId),'DemoSys-IBIZOrder-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizorders/{ibizOrderId}")
    public ResponseEntity<Boolean> removeByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId) {
        Boolean rt = ibizOrderService.remove(ibizOrderId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"订单" },  notes = "IBIZOrder-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-Update-all') or hasPermission(this.ibizOrderService.get(#ibizOrderId),'DemoSys-IBIZOrder-Update')")
    @VersionCheck(entity = "ibizorder" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizorders/{ibizOrderId}")
    public ResponseEntity<IBIZOrderDTO> updateByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        ibizOrderService.update(domain);
        IBIZOrder rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "BUIAction", tags = {"订单" },  notes = "IBIZOrder-BUIAction")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-BUIAction-all') or hasPermission(this.ibizOrderDtoMapping.toDomain(#dto),'DemoSys-IBIZOrder-BUIAction')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/{ibizOrderId}/buiaction")
    public ResponseEntity<IBIZOrderDTO> buiActionByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        IBIZOrder rt = ibizOrderService.buiAction(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"订单" },  notes = "IBIZOrder-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        Integer rt = ibizOrderService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"订单" },  notes = "IBIZOrder-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/getdraft")
    public ResponseEntity<IBIZOrderDTO> getDraft
            (IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        IBIZOrder rt = ibizOrderService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "MulUpdate", tags = {"订单" },  notes = "IBIZOrder-MulUpdate")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-MulUpdate-all') or hasPermission(this.ibizOrderDtoMapping.toDomain(#dto),'DemoSys-IBIZOrder-MulUpdate')")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizorders/{ibizOrderId}/mulupdate")
    public ResponseEntity<IBIZOrderDTO> mulUpdateByIbizOrderId
            (@PathVariable("ibizOrderId") String ibizOrderId, @Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        domain.setIbizOrderId(ibizOrderId);
        IBIZOrder rt = ibizOrderService.mulUpdate(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"订单" },  notes = "IBIZOrder-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-Save-all') or hasPermission(this.ibizOrderDtoMapping.toDomain(#dto),'DemoSys-IBIZOrder-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizorders/save")
    public ResponseEntity<IBIZOrderDTO> save
            (@Validated @RequestBody IBIZOrderDTO dto) {
        IBIZOrder domain = ibizOrderDtoMapping.toDomain(dto);
        ibizOrderService.save(domain);
        IBIZOrder rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizOrderDtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCSDY", tags = {"订单" },  notes = "IBIZOrder-FetchCSDY")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCSDY-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchcsdy")
    public ResponseEntity<List<IBIZOrderDTO>> fetchCsdy
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchCsdy(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchCurState30", tags = {"订单" },  notes = "IBIZOrder-FetchCurState30")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchCurState30-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchcurstate30")
    public ResponseEntity<List<IBIZOrderDTO>> fetchCurState30
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchCurState30(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDDJETJBB", tags = {"订单" },  notes = "IBIZOrder-FetchDDJETJBB")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDJETJBB-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchddjetjbb")
    public ResponseEntity<List<IBIZOrderDTO>> fetchDdjetjbb
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchDdjetjbb(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDDReport", tags = {"订单" },  notes = "IBIZOrder-FetchDDReport")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDDReport-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchddreport")
    public ResponseEntity<List<IBIZOrderDTO>> fetchDdReport
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchDdReport(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDYDDMXSJY", tags = {"订单" },  notes = "IBIZOrder-FetchDYDDMXSJY")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDYDDMXSJY-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchdyddmxsjy")
    public ResponseEntity<List<IBIZOrderDTO>> fetchDyddmxsjy
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchDyddmxsjy(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"订单" },  notes = "IBIZOrder-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchDefault-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchdefault")
    public ResponseEntity<List<IBIZOrderDTO>> fetchDefault
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchDefault(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchEchartsDefaultDataSource", tags = {"订单" },  notes = "IBIZOrder-FetchEchartsDefaultDataSource")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchEchartsDefaultDataSource-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchechartsdefaultdatasource")
    public ResponseEntity<List<IBIZOrderDTO>> fetchEchartsDefaultDataSource
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchEchartsDefaultDataSource(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchGaugeDataSource", tags = {"订单" },  notes = "IBIZOrder-FetchGaugeDataSource")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSource-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchgaugedatasource")
    public ResponseEntity<List<IBIZOrderDTO>> fetchGaugeDataSource
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchGaugeDataSource(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchGaugeDataSourceByTime", tags = {"订单" },  notes = "IBIZOrder-FetchGaugeDataSourceByTime")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchGaugeDataSourceByTime-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchgaugedatasourcebytime")
    public ResponseEntity<List<IBIZOrderDTO>> fetchGaugeDataSourceByTime
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchGaugeDataSourceByTime(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchLOGIC_22", tags = {"订单" },  notes = "IBIZOrder-FetchLOGIC_22")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchLOGIC_22-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchlogic_22")
    public ResponseEntity<List<IBIZOrderDTO>> fetchLogic22
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchLogic22(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchRadarDataSource", tags = {"订单" },  notes = "IBIZOrder-FetchRadarDataSource")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchRadarDataSource-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchradardatasource")
    public ResponseEntity<List<IBIZOrderDTO>> fetchRadarDataSource
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchRadarDataSource(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchSHZOrder", tags = {"订单" },  notes = "IBIZOrder-FetchSHZOrder")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchSHZOrder-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchshzorder")
    public ResponseEntity<List<IBIZOrderDTO>> fetchShzOrder
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchShzOrder(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchState10", tags = {"订单" },  notes = "IBIZOrder-FetchState10")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState10-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchstate10")
    public ResponseEntity<List<IBIZOrderDTO>> fetchState10
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchState10(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchState30", tags = {"订单" },  notes = "IBIZOrder-FetchState30")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState30-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchstate30")
    public ResponseEntity<List<IBIZOrderDTO>> fetchState30
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchState30(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchState40", tags = {"订单" },  notes = "IBIZOrder-FetchState40")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchState40-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchstate40")
    public ResponseEntity<List<IBIZOrderDTO>> fetchState40
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchState40(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchXECX", tags = {"订单" },  notes = "IBIZOrder-FetchXECX")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrder-searchXECX-all','DemoSys-IBIZOrder-Get-all') or hasPermission(#dto,'DemoSys-IBIZOrder-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizorders/fetchxecx")
    public ResponseEntity<List<IBIZOrderDTO>> fetchXecx
            (IBIZOrderSearchContext dto) {
        Page<IBIZOrder> domains = ibizOrderService.searchXecx(dto) ;
        List<IBIZOrderDTO> list = ibizOrderDtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrder-Create-all')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorders/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderDTO> dtos) {
        ibizOrderService.createBatch(ibizOrderDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrder-Update-all')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizorders/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderDTO> dtos) {
        ibizOrderService.updateBatch(ibizOrderDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrder-Save-all')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorders/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderDTO> dtos) {
        ibizOrderService.saveBatch(ibizOrderDtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrder-Save-all')")
    @ApiOperation(value = "批量导入订单", tags = {"订单" },  notes = "批量导入订单")
	@RequestMapping(method = RequestMethod.POST, value = "ibizorders/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZOrderDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZOrder> list=ibizOrderDtoMapping.toDomain(dtos);
            List<IBIZOrder> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizOrderService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZOrder-Remove-all')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizorders","/ibizorders/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizOrderService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
