package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZCustomer_INTF;
import cn.ibizlab.core.sample.service.IBIZCustomer_INTFService;
import cn.ibizlab.core.sample.filter.IBIZCustomer_INTFSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"客户" })
@RestController("demoapi-ibizcustomer_intf")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZCustomer_INTFResource {

    @Autowired
    public IBIZCustomer_INTFService ibizCustomerIntfService;

    @Autowired
    @Lazy
    public IBIZCustomer_INTFDTOMapping ibizCustomerIntfdtoMapping;


    @ApiOperation(value = "创建Create", tags = {"客户" },  notes = "IBIZCustomer_INTF-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-Create-all') or hasPermission(this.ibizCustomerIntfdtoMapping.toDomain(#dto),'DemoSys-IBIZCustomer_INTF-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs")
    public ResponseEntity<IBIZCustomer_INTFDTO> create
            (@Validated @RequestBody IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        ibizCustomerIntfService.create(domain);
        IBIZCustomer_INTF rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"客户" },  notes = "IBIZCustomer_INTF-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-Get-all') or hasPermission(this.ibizCustomerIntfdtoMapping.toDomain(returnObject.body),'DemoSys-IBIZCustomer_INTF-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomerintfs/{ibizCustomerId}")
    public ResponseEntity<IBIZCustomer_INTFDTO> getByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId) {
        IBIZCustomer_INTF rt = ibizCustomerIntfService.get(ibizCustomerId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"客户" },  notes = "IBIZCustomer_INTF-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-Remove-all') or hasPermission(this.ibizCustomerIntfService.get(#ibizCustomerId),'DemoSys-IBIZCustomer_INTF-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizcustomerintfs/{ibizCustomerId}")
    public ResponseEntity<Boolean> removeByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId) {
        Boolean rt = ibizCustomerIntfService.remove(ibizCustomerId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"客户" },  notes = "IBIZCustomer_INTF-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-Update-all') or hasPermission(this.ibizCustomerIntfService.get(#ibizCustomerId),'DemoSys-IBIZCustomer_INTF-Update')")
    @VersionCheck(entity = "ibizcustomer_intf" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizcustomerintfs/{ibizCustomerId}")
    public ResponseEntity<IBIZCustomer_INTFDTO> updateByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId, @Validated @RequestBody IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        domain.setIbizCustomerId(ibizCustomerId);
        ibizCustomerIntfService.update(domain);
        IBIZCustomer_INTF rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"客户" },  notes = "IBIZCustomer_INTF-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        Integer rt = ibizCustomerIntfService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"客户" },  notes = "IBIZCustomer_INTF-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomerintfs/getdraft")
    public ResponseEntity<IBIZCustomer_INTFDTO> getDraft
            (IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        IBIZCustomer_INTF rt = ibizCustomerIntfService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"客户" },  notes = "IBIZCustomer_INTF-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-Save-all') or hasPermission(this.ibizCustomerIntfdtoMapping.toDomain(#dto),'DemoSys-IBIZCustomer_INTF-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/save")
    public ResponseEntity<IBIZCustomer_INTFDTO> save
            (@Validated @RequestBody IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        ibizCustomerIntfService.save(domain);
        IBIZCustomer_INTF rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "XXX", tags = {"客户" },  notes = "IBIZCustomer_INTF-XXX")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-XXX-all') or hasPermission(this.ibizCustomerIntfdtoMapping.toDomain(#dto),'DemoSys-IBIZCustomer_INTF-XXX')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/{ibizCustomerId}/xxx")
    public ResponseEntity<IBIZCustomer_INTFDTO> xxxByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId, @Validated @RequestBody IBIZCustomer_INTFDTO dto) {
        IBIZCustomer_INTF domain = ibizCustomerIntfdtoMapping.toDomain(dto);
        domain.setIbizCustomerId(ibizCustomerId);
        IBIZCustomer_INTF rt = ibizCustomerIntfService.xxx(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerIntfdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCurCustomer", tags = {"客户" },  notes = "IBIZCustomer_INTF-FetchCurCustomer")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchCurCustomer-all','DemoSys-IBIZCustomer_INTF-Get-all') or hasPermission(#dto,'DemoSys-IBIZCustomer_INTF-Get')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/fetchcurcustomer")
    public ResponseEntity<List<IBIZCustomer_INTFDTO>> fetchCurCustomer
            (@Validated @RequestBody IBIZCustomer_INTFSearchContext dto) {
        Page<IBIZCustomer_INTF> domains = ibizCustomerIntfService.searchCurCustomer(dto) ;
        List<IBIZCustomer_INTFDTO> list = ibizCustomerIntfdtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"客户" },  notes = "IBIZCustomer_INTF-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomer_INTF-searchDefault-all','DemoSys-IBIZCustomer_INTF-Get-all') or hasPermission(#dto,'DemoSys-IBIZCustomer_INTF-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomerintfs/fetchdefault")
    public ResponseEntity<List<IBIZCustomer_INTFDTO>> fetchDefault
            (IBIZCustomer_INTFSearchContext dto) {
        Page<IBIZCustomer_INTF> domains = ibizCustomerIntfService.searchDefault(dto) ;
        List<IBIZCustomer_INTFDTO> list = ibizCustomerIntfdtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomer_INTF-Create-all')")
    @ApiOperation(value = "批量新建客户", tags = {"客户" },  notes = "批量新建客户")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZCustomer_INTFDTO> dtos) {
        ibizCustomerIntfService.createBatch(ibizCustomerIntfdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomer_INTF-Update-all')")
    @ApiOperation(value = "批量更新客户", tags = {"客户" },  notes = "批量更新客户")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizcustomerintfs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZCustomer_INTFDTO> dtos) {
        ibizCustomerIntfService.updateBatch(ibizCustomerIntfdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomer_INTF-Save-all')")
    @ApiOperation(value = "批量保存客户", tags = {"客户" },  notes = "批量保存客户")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZCustomer_INTFDTO> dtos) {
        ibizCustomerIntfService.saveBatch(ibizCustomerIntfdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomer_INTF-Save-all')")
    @ApiOperation(value = "批量导入客户", tags = {"客户" },  notes = "批量导入客户")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomerintfs/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZCustomer_INTFDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZCustomer_INTF> list=ibizCustomerIntfdtoMapping.toDomain(dtos);
            List<IBIZCustomer_INTF> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizCustomerIntfService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomer_INTF-Remove-all')")
    @ApiOperation(value = "批量删除客户", tags = {"客户" },  notes = "批量删除客户")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizcustomerintfs","/ibizcustomerintfs/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizCustomerIntfService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
