import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { UILogicParamBase } from "./ui-logic-param-base";

/**
 * 导航上下文绑定参数
 *
 * @export
 * @class UILogicNavContextParam
 */
export class UILogicNavContextParam extends UILogicParamBase {

    /**
     * Creates an instance of UILogicNavContextParam.
     * @param {*} opts
     * @memberof UILogicNavContextParam
     */
    public constructor(opts: any) {
        super(opts);
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UILogicNavContextParam
     */
    protected init(params: any) {
        this.logicParamType = UILogicParamType.navContextParam;
        this.setReal(this.getNavContextParam(params));
    }

    /**
     * 获取导航上下文绑定参数
     *
     * @private
     * @param {any} params
     * @memberof UILogicNavContextParam
     */
    private getNavContextParam(params: any) {
        const { context } = params;
        return context;
    }
}