package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;

/**
 * 服务DTO对象[IBIZSample0005DTO]
 */
@Data
public class IBIZSample0005DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [JE]
     *
     */
    @JSONField(name = "je")
    @JsonProperty("je")
    private BigDecimal je;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfinstanceid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String updateman;

    /**
     * 属性 [MMDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "mmdate" , format="yyyy-MM-dd")
    @JsonProperty("mmdate")
    private Timestamp mmdate;

    /**
     * 属性 [IBIZSAMPLE0005ID]
     *
     */
    @JSONField(name = "ibizsample0005id")
    @JsonProperty("ibizsample0005id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String ibizsample0005id;

    /**
     * 属性 [WFVERSION]
     *
     */
    @JSONField(name = "wfversion")
    @JsonProperty("wfversion")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    private String wfversion;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [WFMMSTEP]
     *
     */
    @JSONField(name = "wfmmstep")
    @JsonProperty("wfmmstep")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmmstep;

    /**
     * 属性 [WFMMTYPE]
     *
     */
    @JSONField(name = "wfmmtype")
    @JsonProperty("wfmmtype")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmmtype;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String createman;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;

    /**
     * 属性 [IBIZSAMPLE0005NAME]
     *
     */
    @JSONField(name = "ibizsample0005name")
    @JsonProperty("ibizsample0005name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    private String ibizsample0005name;

    /**
     * 属性 [MEMO]
     *
     */
    @JSONField(name = "memo")
    @JsonProperty("memo")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    private String memo;

    /**
     * 属性 [WFMMSTATE]
     *
     */
    @JSONField(name = "wfmmstate")
    @JsonProperty("wfmmstate")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    private String wfmmstate;


    /**
     * 设置 [JE]
     */
    public void setJe(BigDecimal  je){
        this.je = je ;
        this.modify("je",je);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [MMDATE]
     */
    public void setMmdate(Timestamp  mmdate){
        this.mmdate = mmdate ;
        this.modify("mmdate",mmdate);
    }

    /**
     * 设置 [WFVERSION]
     */
    public void setWfversion(String  wfversion){
        this.wfversion = wfversion ;
        this.modify("wfversion",wfversion);
    }

    /**
     * 设置 [WFMMSTEP]
     */
    public void setWfmmstep(String  wfmmstep){
        this.wfmmstep = wfmmstep ;
        this.modify("wfmmstep",wfmmstep);
    }

    /**
     * 设置 [WFMMTYPE]
     */
    public void setWfmmtype(String  wfmmtype){
        this.wfmmtype = wfmmtype ;
        this.modify("wfmmtype",wfmmtype);
    }

    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }

    /**
     * 设置 [IBIZSAMPLE0005NAME]
     */
    public void setIbizsample0005name(String  ibizsample0005name){
        this.ibizsample0005name = ibizsample0005name ;
        this.modify("ibizsample0005name",ibizsample0005name);
    }

    /**
     * 设置 [MEMO]
     */
    public void setMemo(String  memo){
        this.memo = memo ;
        this.modify("memo",memo);
    }

    /**
     * 设置 [WFMMSTATE]
     */
    public void setWfmmstate(String  wfmmstate){
        this.wfmmstate = wfmmstate ;
        this.modify("wfmmstate",wfmmstate);
    }


}


