package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import cn.ibizlab.core.sample.service.IIBIZUNIProductService;
import cn.ibizlab.core.sample.filter.IBIZUNIProductSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"统一产品（索引主实体）" })
@RestController("DemoAPI-ibizuniproduct")
@RequestMapping("")
public class IBIZUNIProductResource {

    @Autowired
    public IIBIZUNIProductService ibizuniproductService;

    @Autowired
    @Lazy
    public IBIZUNIProductMapping ibizuniproductMapping;

    @PreAuthorize("hasPermission(this.ibizuniproductMapping.toDomain(#ibizuniproductdto),'DemoSys-IBIZUNIProduct-Create')")
    @ApiOperation(value = "新建统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "新建统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizuniproducts")
    public ResponseEntity<IBIZUNIProductDTO> create(@Validated @RequestBody IBIZUNIProductDTO ibizuniproductdto) {
        IBIZUNIProduct domain = ibizuniproductMapping.toDomain(ibizuniproductdto);
		ibizuniproductService.create(domain);
        IBIZUNIProductDTO dto = ibizuniproductMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizuniproductMapping.toDomain(#ibizuniproductdtos),'DemoSys-IBIZUNIProduct-Create')")
    @ApiOperation(value = "批量新建统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "批量新建统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizuniproducts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZUNIProductDTO> ibizuniproductdtos) {
        ibizuniproductService.createBatch(ibizuniproductMapping.toDomain(ibizuniproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizuniproduct" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizuniproductService.get(#ibizuniproduct_id),'DemoSys-IBIZUNIProduct-Update')")
    @ApiOperation(value = "更新统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "更新统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizuniproducts/{ibizuniproduct_id}")
    public ResponseEntity<IBIZUNIProductDTO> update(@PathVariable("ibizuniproduct_id") String ibizuniproduct_id, @RequestBody IBIZUNIProductDTO ibizuniproductdto) {
		IBIZUNIProduct domain  = ibizuniproductMapping.toDomain(ibizuniproductdto);
        domain .setIbizuniproductid(ibizuniproduct_id);
		ibizuniproductService.update(domain );
		IBIZUNIProductDTO dto = ibizuniproductMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizuniproductService.getIbizuniproductByEntities(this.ibizuniproductMapping.toDomain(#ibizuniproductdtos)),'DemoSys-IBIZUNIProduct-Update')")
    @ApiOperation(value = "批量更新统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "批量更新统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizuniproducts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZUNIProductDTO> ibizuniproductdtos) {
        ibizuniproductService.updateBatch(ibizuniproductMapping.toDomain(ibizuniproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizuniproductService.get(#ibizuniproduct_id),'DemoSys-IBIZUNIProduct-Remove')")
    @ApiOperation(value = "删除统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "删除统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizuniproducts/{ibizuniproduct_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizuniproduct_id") String ibizuniproduct_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizuniproductService.remove(ibizuniproduct_id));
    }

    @PreAuthorize("hasPermission(this.ibizuniproductService.getIbizuniproductByIds(#ids),'DemoSys-IBIZUNIProduct-Remove')")
    @ApiOperation(value = "批量删除统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "批量删除统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizuniproducts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizuniproductService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizuniproductMapping.toDomain(returnObject.body),'DemoSys-IBIZUNIProduct-Get')")
    @ApiOperation(value = "获取统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "获取统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizuniproducts/{ibizuniproduct_id}")
    public ResponseEntity<IBIZUNIProductDTO> get(@PathVariable("ibizuniproduct_id") String ibizuniproduct_id) {
        IBIZUNIProduct domain = ibizuniproductService.get(ibizuniproduct_id);
        IBIZUNIProductDTO dto = ibizuniproductMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取统一产品（索引主实体）草稿", tags = {"统一产品（索引主实体）" },  notes = "获取统一产品（索引主实体）草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizuniproducts/getdraft")
    public ResponseEntity<IBIZUNIProductDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizuniproductMapping.toDto(ibizuniproductService.getDraft(new IBIZUNIProduct())));
    }

    @ApiOperation(value = "检查统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "检查统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizuniproducts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZUNIProductDTO ibizuniproductdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizuniproductService.checkKey(ibizuniproductMapping.toDomain(ibizuniproductdto)));
    }

    @PreAuthorize("hasPermission(this.ibizuniproductMapping.toDomain(#ibizuniproductdto),'DemoSys-IBIZUNIProduct-Save')")
    @ApiOperation(value = "保存统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "保存统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizuniproducts/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZUNIProductDTO ibizuniproductdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizuniproductService.save(ibizuniproductMapping.toDomain(ibizuniproductdto)));
    }

    @PreAuthorize("hasPermission(this.ibizuniproductMapping.toDomain(#ibizuniproductdtos),'DemoSys-IBIZUNIProduct-Save')")
    @ApiOperation(value = "批量保存统一产品（索引主实体）", tags = {"统一产品（索引主实体）" },  notes = "批量保存统一产品（索引主实体）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizuniproducts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZUNIProductDTO> ibizuniproductdtos) {
        ibizuniproductService.saveBatch(ibizuniproductMapping.toDomain(ibizuniproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZUNIProduct-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZUNIProduct-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"统一产品（索引主实体）" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizuniproducts/fetchdefault")
	public ResponseEntity<List<IBIZUNIProductDTO>> fetchDefault(IBIZUNIProductSearchContext context) {
        Page<IBIZUNIProduct> domains = ibizuniproductService.searchDefault(context) ;
        List<IBIZUNIProductDTO> list = ibizuniproductMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZUNIProduct-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZUNIProduct-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"统一产品（索引主实体）" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizuniproducts/searchdefault")
	public ResponseEntity<Page<IBIZUNIProductDTO>> searchDefault(@RequestBody IBIZUNIProductSearchContext context) {
        Page<IBIZUNIProduct> domains = ibizuniproductService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizuniproductMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZUNIProduct-searchIndexDER-all') and hasPermission(#context,'DemoSys-IBIZUNIProduct-Get')")
	@ApiOperation(value = "获取IndexDER", tags = {"统一产品（索引主实体）" } ,notes = "获取IndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/ibizuniproducts/fetchindexder")
	public ResponseEntity<List<IBIZUNIProductDTO>> fetchIndexDER(IBIZUNIProductSearchContext context) {
        Page<IBIZUNIProduct> domains = ibizuniproductService.searchIndexDER(context) ;
        List<IBIZUNIProductDTO> list = ibizuniproductMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZUNIProduct-searchIndexDER-all') and hasPermission(#context,'DemoSys-IBIZUNIProduct-Get')")
	@ApiOperation(value = "查询IndexDER", tags = {"统一产品（索引主实体）" } ,notes = "查询IndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/ibizuniproducts/searchindexder")
	public ResponseEntity<Page<IBIZUNIProductDTO>> searchIndexDER(@RequestBody IBIZUNIProductSearchContext context) {
        Page<IBIZUNIProduct> domains = ibizuniproductService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizuniproductMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

