package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0005;
import cn.ibizlab.core.sample.service.IIBIZSample0005Service;
import cn.ibizlab.core.sample.filter.IBIZSample0005SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"多模式流程" })
@RestController("DemoAPI-ibizsample0005")
@RequestMapping("")
public class IBIZSample0005Resource {

    @Autowired
    public IIBIZSample0005Service ibizsample0005Service;

    @Autowired
    @Lazy
    public IBIZSample0005Mapping ibizsample0005Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0005Mapping.toDomain(#ibizsample0005dto),'DemoSys-IBIZSample0005-Create')")
    @ApiOperation(value = "新建多模式流程", tags = {"多模式流程" },  notes = "新建多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0005s")
    public ResponseEntity<IBIZSample0005DTO> create(@Validated @RequestBody IBIZSample0005DTO ibizsample0005dto) {
        IBIZSample0005 domain = ibizsample0005Mapping.toDomain(ibizsample0005dto);
		ibizsample0005Service.create(domain);
        IBIZSample0005DTO dto = ibizsample0005Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Mapping.toDomain(#ibizsample0005dtos),'DemoSys-IBIZSample0005-Create')")
    @ApiOperation(value = "批量新建多模式流程", tags = {"多模式流程" },  notes = "批量新建多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0005s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0005DTO> ibizsample0005dtos) {
        ibizsample0005Service.createBatch(ibizsample0005Mapping.toDomain(ibizsample0005dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0005" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0005Service.get(#ibizsample0005_id),'DemoSys-IBIZSample0005-Update')")
    @ApiOperation(value = "更新多模式流程", tags = {"多模式流程" },  notes = "更新多模式流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0005s/{ibizsample0005_id}")
    public ResponseEntity<IBIZSample0005DTO> update(@PathVariable("ibizsample0005_id") String ibizsample0005_id, @RequestBody IBIZSample0005DTO ibizsample0005dto) {
		IBIZSample0005 domain  = ibizsample0005Mapping.toDomain(ibizsample0005dto);
        domain .setIbizsample0005id(ibizsample0005_id);
		ibizsample0005Service.update(domain );
		IBIZSample0005DTO dto = ibizsample0005Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Service.getIbizsample0005ByEntities(this.ibizsample0005Mapping.toDomain(#ibizsample0005dtos)),'DemoSys-IBIZSample0005-Update')")
    @ApiOperation(value = "批量更新多模式流程", tags = {"多模式流程" },  notes = "批量更新多模式流程")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0005s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0005DTO> ibizsample0005dtos) {
        ibizsample0005Service.updateBatch(ibizsample0005Mapping.toDomain(ibizsample0005dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Service.get(#ibizsample0005_id),'DemoSys-IBIZSample0005-Remove')")
    @ApiOperation(value = "删除多模式流程", tags = {"多模式流程" },  notes = "删除多模式流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0005s/{ibizsample0005_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0005_id") String ibizsample0005_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0005Service.remove(ibizsample0005_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Service.getIbizsample0005ByIds(#ids),'DemoSys-IBIZSample0005-Remove')")
    @ApiOperation(value = "批量删除多模式流程", tags = {"多模式流程" },  notes = "批量删除多模式流程")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0005s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0005Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0005Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0005-Get')")
    @ApiOperation(value = "获取多模式流程", tags = {"多模式流程" },  notes = "获取多模式流程")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0005s/{ibizsample0005_id}")
    public ResponseEntity<IBIZSample0005DTO> get(@PathVariable("ibizsample0005_id") String ibizsample0005_id) {
        IBIZSample0005 domain = ibizsample0005Service.get(ibizsample0005_id);
        IBIZSample0005DTO dto = ibizsample0005Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取多模式流程草稿", tags = {"多模式流程" },  notes = "获取多模式流程草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0005s/getdraft")
    public ResponseEntity<IBIZSample0005DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0005Mapping.toDto(ibizsample0005Service.getDraft(new IBIZSample0005())));
    }

    @ApiOperation(value = "检查多模式流程", tags = {"多模式流程" },  notes = "检查多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0005s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0005DTO ibizsample0005dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0005Service.checkKey(ibizsample0005Mapping.toDomain(ibizsample0005dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Mapping.toDomain(#ibizsample0005dto),'DemoSys-IBIZSample0005-Save')")
    @ApiOperation(value = "保存多模式流程", tags = {"多模式流程" },  notes = "保存多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0005s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0005DTO ibizsample0005dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0005Service.save(ibizsample0005Mapping.toDomain(ibizsample0005dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0005Mapping.toDomain(#ibizsample0005dtos),'DemoSys-IBIZSample0005-Save')")
    @ApiOperation(value = "批量保存多模式流程", tags = {"多模式流程" },  notes = "批量保存多模式流程")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0005s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0005DTO> ibizsample0005dtos) {
        ibizsample0005Service.saveBatch(ibizsample0005Mapping.toDomain(ibizsample0005dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0005-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"多模式流程" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0005s/fetchdefault")
	public ResponseEntity<List<IBIZSample0005DTO>> fetchDefault(IBIZSample0005SearchContext context) {
        Page<IBIZSample0005> domains = ibizsample0005Service.searchDefault(context) ;
        List<IBIZSample0005DTO> list = ibizsample0005Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0005-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0005-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"多模式流程" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0005s/searchdefault")
	public ResponseEntity<Page<IBIZSample0005DTO>> searchDefault(@RequestBody IBIZSample0005SearchContext context) {
        Page<IBIZSample0005> domains = ibizsample0005Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0005Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

