package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0015;
import cn.ibizlab.core.sample.service.IIBIZSample0015Service;
import cn.ibizlab.core.sample.filter.IBIZSample0015SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"项目" })
@RestController("DemoAPI-ibizsample0015")
@RequestMapping("")
public class IBIZSample0015Resource {

    @Autowired
    public IIBIZSample0015Service ibizsample0015Service;

    @Autowired
    @Lazy
    public IBIZSample0015Mapping ibizsample0015Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0015Mapping.toDomain(#ibizsample0015dto),'DemoSys-IBIZSample0015-Create')")
    @ApiOperation(value = "新建项目", tags = {"项目" },  notes = "新建项目")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0015s")
    public ResponseEntity<IBIZSample0015DTO> create(@Validated @RequestBody IBIZSample0015DTO ibizsample0015dto) {
        IBIZSample0015 domain = ibizsample0015Mapping.toDomain(ibizsample0015dto);
		ibizsample0015Service.create(domain);
        IBIZSample0015DTO dto = ibizsample0015Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Mapping.toDomain(#ibizsample0015dtos),'DemoSys-IBIZSample0015-Create')")
    @ApiOperation(value = "批量新建项目", tags = {"项目" },  notes = "批量新建项目")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0015s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0015DTO> ibizsample0015dtos) {
        ibizsample0015Service.createBatch(ibizsample0015Mapping.toDomain(ibizsample0015dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0015" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0015Service.get(#ibizsample0015_id),'DemoSys-IBIZSample0015-Update')")
    @ApiOperation(value = "更新项目", tags = {"项目" },  notes = "更新项目")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0015s/{ibizsample0015_id}")
    public ResponseEntity<IBIZSample0015DTO> update(@PathVariable("ibizsample0015_id") String ibizsample0015_id, @RequestBody IBIZSample0015DTO ibizsample0015dto) {
		IBIZSample0015 domain  = ibizsample0015Mapping.toDomain(ibizsample0015dto);
        domain .setIbizsample0015id(ibizsample0015_id);
		ibizsample0015Service.update(domain );
		IBIZSample0015DTO dto = ibizsample0015Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Service.getIbizsample0015ByEntities(this.ibizsample0015Mapping.toDomain(#ibizsample0015dtos)),'DemoSys-IBIZSample0015-Update')")
    @ApiOperation(value = "批量更新项目", tags = {"项目" },  notes = "批量更新项目")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0015s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0015DTO> ibizsample0015dtos) {
        ibizsample0015Service.updateBatch(ibizsample0015Mapping.toDomain(ibizsample0015dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Service.get(#ibizsample0015_id),'DemoSys-IBIZSample0015-Remove')")
    @ApiOperation(value = "删除项目", tags = {"项目" },  notes = "删除项目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0015s/{ibizsample0015_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0015_id") String ibizsample0015_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0015Service.remove(ibizsample0015_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Service.getIbizsample0015ByIds(#ids),'DemoSys-IBIZSample0015-Remove')")
    @ApiOperation(value = "批量删除项目", tags = {"项目" },  notes = "批量删除项目")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0015s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0015Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0015Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0015-Get')")
    @ApiOperation(value = "获取项目", tags = {"项目" },  notes = "获取项目")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0015s/{ibizsample0015_id}")
    public ResponseEntity<IBIZSample0015DTO> get(@PathVariable("ibizsample0015_id") String ibizsample0015_id) {
        IBIZSample0015 domain = ibizsample0015Service.get(ibizsample0015_id);
        IBIZSample0015DTO dto = ibizsample0015Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取项目草稿", tags = {"项目" },  notes = "获取项目草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0015s/getdraft")
    public ResponseEntity<IBIZSample0015DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0015Mapping.toDto(ibizsample0015Service.getDraft(new IBIZSample0015())));
    }

    @ApiOperation(value = "检查项目", tags = {"项目" },  notes = "检查项目")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0015s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0015DTO ibizsample0015dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0015Service.checkKey(ibizsample0015Mapping.toDomain(ibizsample0015dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Mapping.toDomain(#ibizsample0015dto),'DemoSys-IBIZSample0015-Save')")
    @ApiOperation(value = "保存项目", tags = {"项目" },  notes = "保存项目")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0015s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0015DTO ibizsample0015dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0015Service.save(ibizsample0015Mapping.toDomain(ibizsample0015dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0015Mapping.toDomain(#ibizsample0015dtos),'DemoSys-IBIZSample0015-Save')")
    @ApiOperation(value = "批量保存项目", tags = {"项目" },  notes = "批量保存项目")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0015s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0015DTO> ibizsample0015dtos) {
        ibizsample0015Service.saveBatch(ibizsample0015Mapping.toDomain(ibizsample0015dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0015-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"项目" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0015s/fetchdefault")
	public ResponseEntity<List<IBIZSample0015DTO>> fetchDefault(IBIZSample0015SearchContext context) {
        Page<IBIZSample0015> domains = ibizsample0015Service.searchDefault(context) ;
        List<IBIZSample0015DTO> list = ibizsample0015Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0015-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0015-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"项目" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0015s/searchdefault")
	public ResponseEntity<Page<IBIZSample0015DTO>> searchDefault(@RequestBody IBIZSample0015SearchContext context) {
        Page<IBIZSample0015> domains = ibizsample0015Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0015Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

