package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0012;
import cn.ibizlab.core.sample.service.IIBIZSample0012Service;
import cn.ibizlab.core.sample.filter.IBIZSample0012SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单" })
@RestController("DemoAPI-ibizsample0012")
@RequestMapping("")
public class IBIZSample0012Resource {

    @Autowired
    public IIBIZSample0012Service ibizsample0012Service;

    @Autowired
    @Lazy
    public IBIZSample0012Mapping ibizsample0012Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0012Mapping.toDomain(#ibizsample0012dto),'DemoSys-IBIZSample0012-Create')")
    @ApiOperation(value = "新建订单", tags = {"订单" },  notes = "新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0012s")
    public ResponseEntity<IBIZSample0012DTO> create(@Validated @RequestBody IBIZSample0012DTO ibizsample0012dto) {
        IBIZSample0012 domain = ibizsample0012Mapping.toDomain(ibizsample0012dto);
		ibizsample0012Service.create(domain);
        IBIZSample0012DTO dto = ibizsample0012Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Mapping.toDomain(#ibizsample0012dtos),'DemoSys-IBIZSample0012-Create')")
    @ApiOperation(value = "批量新建订单", tags = {"订单" },  notes = "批量新建订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0012s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0012DTO> ibizsample0012dtos) {
        ibizsample0012Service.createBatch(ibizsample0012Mapping.toDomain(ibizsample0012dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0012" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0012Service.get(#ibizsample0012_id),'DemoSys-IBIZSample0012-Update')")
    @ApiOperation(value = "更新订单", tags = {"订单" },  notes = "更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0012s/{ibizsample0012_id}")
    public ResponseEntity<IBIZSample0012DTO> update(@PathVariable("ibizsample0012_id") String ibizsample0012_id, @RequestBody IBIZSample0012DTO ibizsample0012dto) {
		IBIZSample0012 domain  = ibizsample0012Mapping.toDomain(ibizsample0012dto);
        domain .setIbizsample0012id(ibizsample0012_id);
		ibizsample0012Service.update(domain );
		IBIZSample0012DTO dto = ibizsample0012Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Service.getIbizsample0012ByEntities(this.ibizsample0012Mapping.toDomain(#ibizsample0012dtos)),'DemoSys-IBIZSample0012-Update')")
    @ApiOperation(value = "批量更新订单", tags = {"订单" },  notes = "批量更新订单")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0012s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0012DTO> ibizsample0012dtos) {
        ibizsample0012Service.updateBatch(ibizsample0012Mapping.toDomain(ibizsample0012dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Service.get(#ibizsample0012_id),'DemoSys-IBIZSample0012-Remove')")
    @ApiOperation(value = "删除订单", tags = {"订单" },  notes = "删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0012s/{ibizsample0012_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0012_id") String ibizsample0012_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0012Service.remove(ibizsample0012_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Service.getIbizsample0012ByIds(#ids),'DemoSys-IBIZSample0012-Remove')")
    @ApiOperation(value = "批量删除订单", tags = {"订单" },  notes = "批量删除订单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0012s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0012Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0012Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0012-Get')")
    @ApiOperation(value = "获取订单", tags = {"订单" },  notes = "获取订单")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0012s/{ibizsample0012_id}")
    public ResponseEntity<IBIZSample0012DTO> get(@PathVariable("ibizsample0012_id") String ibizsample0012_id) {
        IBIZSample0012 domain = ibizsample0012Service.get(ibizsample0012_id);
        IBIZSample0012DTO dto = ibizsample0012Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单草稿", tags = {"订单" },  notes = "获取订单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0012s/getdraft")
    public ResponseEntity<IBIZSample0012DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0012Mapping.toDto(ibizsample0012Service.getDraft(new IBIZSample0012())));
    }

    @ApiOperation(value = "检查订单", tags = {"订单" },  notes = "检查订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0012s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0012DTO ibizsample0012dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0012Service.checkKey(ibizsample0012Mapping.toDomain(ibizsample0012dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Mapping.toDomain(#ibizsample0012dto),'DemoSys-IBIZSample0012-Save')")
    @ApiOperation(value = "保存订单", tags = {"订单" },  notes = "保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0012s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0012DTO ibizsample0012dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0012Service.save(ibizsample0012Mapping.toDomain(ibizsample0012dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0012Mapping.toDomain(#ibizsample0012dtos),'DemoSys-IBIZSample0012-Save')")
    @ApiOperation(value = "批量保存订单", tags = {"订单" },  notes = "批量保存订单")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0012s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0012DTO> ibizsample0012dtos) {
        ibizsample0012Service.saveBatch(ibizsample0012Mapping.toDomain(ibizsample0012dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0012-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0012s/fetchdefault")
	public ResponseEntity<List<IBIZSample0012DTO>> fetchDefault(IBIZSample0012SearchContext context) {
        Page<IBIZSample0012> domains = ibizsample0012Service.searchDefault(context) ;
        List<IBIZSample0012DTO> list = ibizsample0012Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0012-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0012-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0012s/searchdefault")
	public ResponseEntity<Page<IBIZSample0012DTO>> searchDefault(@RequestBody IBIZSample0012SearchContext context) {
        Page<IBIZSample0012> domains = ibizsample0012Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0012Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

