package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZCustomerMG;
import cn.ibizlab.core.sample.service.IIBIZCustomerMGService;
import cn.ibizlab.core.sample.filter.IBIZCustomerMGSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"客户管理" })
@RestController("DemoAPI-ibizcustomermg")
@RequestMapping("")
public class IBIZCustomerMGResource {

    @Autowired
    public IIBIZCustomerMGService ibizcustomermgService;

    @Autowired
    @Lazy
    public IBIZCustomerMGMapping ibizcustomermgMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Create-all')")
    @ApiOperation(value = "新建客户管理", tags = {"客户管理" },  notes = "新建客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomermgs")
    public ResponseEntity<IBIZCustomerMGDTO> create(@Validated @RequestBody IBIZCustomerMGDTO ibizcustomermgdto) {
        IBIZCustomerMG domain = ibizcustomermgMapping.toDomain(ibizcustomermgdto);
		ibizcustomermgService.create(domain);
        IBIZCustomerMGDTO dto = ibizcustomermgMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Create-all')")
    @ApiOperation(value = "批量新建客户管理", tags = {"客户管理" },  notes = "批量新建客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomermgs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZCustomerMGDTO> ibizcustomermgdtos) {
        ibizcustomermgService.createBatch(ibizcustomermgMapping.toDomain(ibizcustomermgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Update-all')")
    @ApiOperation(value = "更新客户管理", tags = {"客户管理" },  notes = "更新客户管理")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustomermgs/{ibizcustomermg_id}")
    public ResponseEntity<IBIZCustomerMGDTO> update(@PathVariable("ibizcustomermg_id") String ibizcustomermg_id, @RequestBody IBIZCustomerMGDTO ibizcustomermgdto) {
		IBIZCustomerMG domain  = ibizcustomermgMapping.toDomain(ibizcustomermgdto);
        domain .setIbizcustomerid(ibizcustomermg_id);
		ibizcustomermgService.update(domain );
		IBIZCustomerMGDTO dto = ibizcustomermgMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Update-all')")
    @ApiOperation(value = "批量更新客户管理", tags = {"客户管理" },  notes = "批量更新客户管理")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizcustomermgs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZCustomerMGDTO> ibizcustomermgdtos) {
        ibizcustomermgService.updateBatch(ibizcustomermgMapping.toDomain(ibizcustomermgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Remove-all')")
    @ApiOperation(value = "删除客户管理", tags = {"客户管理" },  notes = "删除客户管理")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustomermgs/{ibizcustomermg_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizcustomermg_id") String ibizcustomermg_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizcustomermgService.remove(ibizcustomermg_id));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Remove-all')")
    @ApiOperation(value = "批量删除客户管理", tags = {"客户管理" },  notes = "批量删除客户管理")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizcustomermgs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizcustomermgService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Get-all')")
    @ApiOperation(value = "获取客户管理", tags = {"客户管理" },  notes = "获取客户管理")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustomermgs/{ibizcustomermg_id}")
    public ResponseEntity<IBIZCustomerMGDTO> get(@PathVariable("ibizcustomermg_id") String ibizcustomermg_id) {
        IBIZCustomerMG domain = ibizcustomermgService.get(ibizcustomermg_id);
        IBIZCustomerMGDTO dto = ibizcustomermgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取客户管理草稿", tags = {"客户管理" },  notes = "获取客户管理草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizcustomermgs/getdraft")
    public ResponseEntity<IBIZCustomerMGDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomermgMapping.toDto(ibizcustomermgService.getDraft(new IBIZCustomerMG())));
    }

    @ApiOperation(value = "检查客户管理", tags = {"客户管理" },  notes = "检查客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomermgs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZCustomerMGDTO ibizcustomermgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizcustomermgService.checkKey(ibizcustomermgMapping.toDomain(ibizcustomermgdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Save-all')")
    @ApiOperation(value = "保存客户管理", tags = {"客户管理" },  notes = "保存客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomermgs/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZCustomerMGDTO ibizcustomermgdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizcustomermgService.save(ibizcustomermgMapping.toDomain(ibizcustomermgdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Save-all')")
    @ApiOperation(value = "批量保存客户管理", tags = {"客户管理" },  notes = "批量保存客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizcustomermgs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZCustomerMGDTO> ibizcustomermgdtos) {
        ibizcustomermgService.saveBatch(ibizcustomermgMapping.toDomain(ibizcustomermgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-searchDefault-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"客户管理" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomermgs/fetchdefault")
	public ResponseEntity<List<IBIZCustomerMGDTO>> fetchDefault(IBIZCustomerMGSearchContext context) {
        Page<IBIZCustomerMG> domains = ibizcustomermgService.searchDefault(context) ;
        List<IBIZCustomerMGDTO> list = ibizcustomermgMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-searchDefault-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"客户管理" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizcustomermgs/searchdefault")
	public ResponseEntity<Page<IBIZCustomerMGDTO>> searchDefault(@RequestBody IBIZCustomerMGSearchContext context) {
        Page<IBIZCustomerMG> domains = ibizcustomermgService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizcustomermgMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

