/**
 * NewDefault 部件模型
 *
 * @export
 * @class NewDefaultModel
 */
export default class NewDefaultModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof NewDefaultGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof NewDefaultGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'author',
          prop: 'author',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'press',
          prop: 'press',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'ibizbookname',
          prop: 'ibizbookname',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'price',
          prop: 'price',
          dataType: 'FLOAT',
          isEditable:true
        },
        {
          name: 'ibizbookid',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
          isEditable:true
        },
        {
          name: 'type',
          prop: 'type',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'srfmajortext',
          prop: 'ibizbookname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizbookid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizbook',
          prop: 'ibizbookid',
        },
        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}