/**
 * Main5 部件模型
 *
 * @export
 * @class Main5Model
 */
export default class Main5Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main5GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main5GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'author',
          prop: 'author',
          dataType: 'TEXT',
        },
        {
          name: 'press',
          prop: 'press',
          dataType: 'TEXT',
        },
        {
          name: 'ibizbookname',
          prop: 'ibizbookname',
          dataType: 'TEXT',
        },
        {
          name: 'booknumber',
          prop: 'booknumber',
          dataType: 'INT',
        },
        {
          name: 'ibizbookid',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'type',
          prop: 'type',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizbookname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizbookid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizbookid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'ibizbook',
          prop: 'ibizbookid',
        },
      {
        name: 'n_ibizbookname_like',
        prop: 'n_ibizbookname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_price_gtandeq',
        prop: 'n_price_gtandeq',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}