/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
        {
          name: 'orderuid',
          prop: 'orderuid',
          dataType: 'TEXT',
        },
        {
          name: 'IBIZordername',
          prop: 'ibizordername',
          dataType: 'TEXT',
        },
        {
          name: 'IBIZcustomername',
          prop: 'ibizcustomername',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'ordertype',
          prop: 'ordertype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ordertime',
          prop: 'ordertime',
          dataType: 'DATE',
        },
        {
          name: 'orderstate',
          prop: 'orderstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'detailnum',
          prop: 'detailnum',
          dataType: 'INT',
        },
        {
          name: 'amount',
          prop: 'amount',
          dataType: 'FLOAT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
      ]
    }else{
		  return [
        {
          name: 'ibizcustomerid',
          prop: 'ibizcustomerid',
          dataType: 'PICKUP',
        },
        {
          name: 'orderstate',
          prop: 'orderstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ibizorderid',
          prop: 'ibizorderid',
          dataType: 'GUID',
        },
        {
          name: 'wfstep',
          prop: 'wfstep',
          dataType: 'SSCODELIST',
        },
        {
          name: 'ordertime',
          prop: 'ordertime',
          dataType: 'DATE',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'ibizordername',
          prop: 'ibizordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfmstag',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizordername',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizorderid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizorderid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'orderuid',
          prop: 'orderuid',
          dataType: 'TEXT',
        },
        {
          name: 'ibizorder',
          prop: 'ibizorderid',
        },
      {
        name: 'n_ibizordername_like',
        prop: 'n_ibizordername_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_orderstate_eq',
        prop: 'n_orderstate_eq',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_ordertime_gt',
        prop: 'n_ordertime_gt',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_ordertime_lt',
        prop: 'n_ordertime_lt',
        dataType: 'QUERYPARAM'
      },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}