import { Http,Util } from '@/utils';
import EntityService from '../entity-service';
import CountMoneyLogic from '@/service/ibizorder-detail/count-money-logic';
import GetUnitAndPriceLogic from '@/service/ibizorder-detail/get-unit-and-price-logic';



/**
 * 订单明细服务对象基类
 *
 * @export
 * @class IBIZOrderDetailServiceBase
 * @extends {EntityServie}
 */
export default class IBIZOrderDetailServiceBase extends EntityService {

    /**
     * Creates an instance of  IBIZOrderDetailServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZOrderDetailServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof IBIZOrderDetailServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='ibizorderdetail';
        this.APPDEKEY = 'ibizorderdetailid';
        this.APPDENAME = 'ibizorderdetails';
        this.APPDETEXT = 'ibizorderdetailname';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'demosys';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}/select`,isloading);
            
            return res;
    }

    /**
     * SelectTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async SelectTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        // URI参数传递情况未实现
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/ibizorderdetails`,data,isloading);
        
        return res;
    }

    /**
     * CreateTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CreateTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/createtemp`,data,isloading);
            return res;
    }

    /**
     * CreateTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CreateTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/createtempmajor`,data,isloading);
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/ibizorderdetails/${context.ibizorderdetail}`,data,isloading);
            
            return res;
    }

    /**
     * UpdateTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async UpdateTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().put(`/ibizorderdetails/${context.ibizorderdetail}/updatetemp`,data,isloading);
            return res;
    }

    /**
     * UpdateTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async UpdateTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().put(`/ibizorderdetails/${context.ibizorderdetail}/updatetempmajor`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorderdetails/${context.ibizorderdetail}`,isloading);
            return res;
    }

    /**
     * RemoveTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async RemoveTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorderdetails/${context.ibizorderdetail}/removetemp`,isloading);
            return res;
    }

    /**
     * RemoveTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async RemoveTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().delete(`/ibizorderdetails/${context.ibizorderdetail}/removetempmajor`,isloading);
            return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}`,isloading);
            
            return res;
    }

    /**
     * GetTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}/gettemp`,isloading);
            
            return res;
    }

    /**
     * GetTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}/gettempmajor`,isloading);
            
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/ibizorderdetails/getdraft`,isloading);
        res.data.ibizorderdetail = data.ibizorderdetail;
        
        return res;
    }

    /**
     * GetDraftTemp接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetDraftTemp(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/ibizorderdetails/getdrafttemp`,isloading);
        res.data.ibizorderdetail = data.ibizorderdetail;
        
        return res;
    }

    /**
     * GetDraftTempMajor接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetDraftTempMajor(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/ibizorderdetails/${context.ibizorderdetail}/getdrafttempmajor`,isloading);
            
            return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/checkkey`,data,isloading);
            return res;
    }

    /**
     * CountMoney接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async CountMoney(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:CountMoneyLogic = new CountMoneyLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        data = await appLogic.onExecute(context,data,isloading?true:false);
        let res:any ={status:200,data:data};
        return res;
    }

    /**
     * GetUnitAndPrice接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async GetUnitAndPrice(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let appLogic:GetUnitAndPriceLogic = new GetUnitAndPriceLogic({context:JSON.parse(JSON.stringify(context)),data:JSON.parse(JSON.stringify(data))});
        data = await appLogic.onExecute(context,data,isloading?true:false);
        let res:any ={status:200,data:data};
        return res;
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/ibizorderdetails/${context.ibizorderdetail}/save`,data,isloading);
            
            return res;
    }

    /**
     * FetchCSMXDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchCSMXDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchcsmxdy`,tempData,isloading);
        return res;
    }

    /**
     * searchCSMXDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchCSMXDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchcsmxdy`,tempData,isloading);
    }

    /**
     * FetchTempCSMXDY接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchTempCSMXDY(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorderdetails/fetchtempcsmxdy`,data,isloading);
        return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchdefault`,tempData,isloading);
        return res;
    }

    /**
     * searchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchdefault`,tempData,isloading);
    }

    /**
     * FetchTempDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchTempDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorderdetails/fetchtempdefault`,data,isloading);
        return res;
    }

    /**
     * FetchLOGIC_0007接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchLOGIC_0007(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchlogic_0007`,tempData,isloading);
        return res;
    }

    /**
     * searchLOGIC_0007接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchLOGIC_0007(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchlogic_0007`,tempData,isloading);
    }

    /**
     * FetchTempLOGIC_0007接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchTempLOGIC_0007(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorderdetails/fetchtemplogic_0007`,data,isloading);
        return res;
    }

    /**
     * FetchX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        let res:any = Http.getInstance().get(`/ibizorderdetails/fetchx`,tempData,isloading);
        return res;
    }

    /**
     * searchX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async searchX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return await Http.getInstance().post(`/ibizorderdetails/searchx`,tempData,isloading);
    }

    /**
     * FetchTempX接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof IBIZOrderDetailServiceBase
     */
    public async FetchTempX(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any =  Http.getInstance().get(`/ibizorderdetails/fetchtempx`,data,isloading);
        return res;
    }
}