/**
 * 实体数据服务注册中心
 *
 * @export
 * @class EntityServiceRegister
 */
export class EntityServiceRegister {

    /**
     * 所有实体数据服务Map
     *
     * @protected
     * @type {*}
     * @memberof EntityServiceRegister
     */
    protected allEntityService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载实体数据服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof EntityServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of EntityServiceRegister.
     * @memberof EntityServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof EntityServiceRegister
     */
    protected init(): void {
                this.allEntityService.set('ibizsample0006', () => import('@/service/ibizsample0006/ibizsample0006-service'));
        this.allEntityService.set('ibizsample0017', () => import('@/service/ibizsample0017/ibizsample0017-service'));
        this.allEntityService.set('ibizsample0002', () => import('@/service/ibizsample0002/ibizsample0002-service'));
        this.allEntityService.set('ibizsample0010', () => import('@/service/ibizsample0010/ibizsample0010-service'));
        this.allEntityService.set('ibizcustomer_intf', () => import('@/service/ibizcustomer-intf/ibizcustomer-intf-service'));
        this.allEntityService.set('ibizorderdetail', () => import('@/service/ibizorder-detail/ibizorder-detail-service'));
        this.allEntityService.set('ibizsample0016', () => import('@/service/ibizsample0016/ibizsample0016-service'));
        this.allEntityService.set('ibizorder', () => import('@/service/ibizorder/ibizorder-service'));
        this.allEntityService.set('ibizaccount', () => import('@/service/ibizaccount/ibizaccount-service'));
        this.allEntityService.set('ibizcustomermg', () => import('@/service/ibizcustomer-mg/ibizcustomer-mg-service'));
        this.allEntityService.set('ibizordertype', () => import('@/service/ibizorder-type/ibizorder-type-service'));
        this.allEntityService.set('ibizsample0014', () => import('@/service/ibizsample0014/ibizsample0014-service'));
        this.allEntityService.set('ibizsample0001', () => import('@/service/ibizsample0001/ibizsample0001-service'));
        this.allEntityService.set('ibizsample0008', () => import('@/service/ibizsample0008/ibizsample0008-service'));
        this.allEntityService.set('ibizbook', () => import('@/service/ibizbook/ibizbook-service'));
        this.allEntityService.set('ibizsample0015', () => import('@/service/ibizsample0015/ibizsample0015-service'));
        this.allEntityService.set('ibizsample0020', () => import('@/service/ibizsample0020/ibizsample0020-service'));
        this.allEntityService.set('ibizsample0011', () => import('@/service/ibizsample0011/ibizsample0011-service'));
        this.allEntityService.set('ibizcpu', () => import('@/service/ibizcpu/ibizcpu-service'));
        this.allEntityService.set('ibizsample0012', () => import('@/service/ibizsample0012/ibizsample0012-service'));
        this.allEntityService.set('ibizsample', () => import('@/service/ibizsample/ibizsample-service'));
        this.allEntityService.set('ibizsupplier', () => import('@/service/ibizsupplier/ibizsupplier-service'));
        this.allEntityService.set('ibizsample0004', () => import('@/service/ibizsample0004/ibizsample0004-service'));
        this.allEntityService.set('ibizsoftwaresuit', () => import('@/service/ibizsoftware-suit/ibizsoftware-suit-service'));
        this.allEntityService.set('ibizhardware', () => import('@/service/ibizhardware/ibizhardware-service'));
        this.allEntityService.set('ibizsample0007', () => import('@/service/ibizsample0007/ibizsample0007-service'));
        this.allEntityService.set('ibizsample0018', () => import('@/service/ibizsample0018/ibizsample0018-service'));
        this.allEntityService.set('ibizsample0019', () => import('@/service/ibizsample0019/ibizsample0019-service'));
        this.allEntityService.set('ibizstorage', () => import('@/service/ibizstorage/ibizstorage-service'));
        this.allEntityService.set('ibizsample0003', () => import('@/service/ibizsample0003/ibizsample0003-service'));
        this.allEntityService.set('ibizsample0009', () => import('@/service/ibizsample0009/ibizsample0009-service'));
        this.allEntityService.set('ibizsample0013', () => import('@/service/ibizsample0013/ibizsample0013-service'));
        this.allEntityService.set('ibizcustomer', () => import('@/service/ibizcustomer/ibizcustomer-service'));
        this.allEntityService.set('ibizcustom', () => import('@/service/ibizcustom/ibizcustom-service'));
        this.allEntityService.set('ibizsample0005', () => import('@/service/ibizsample0005/ibizsample0005-service'));
        this.allEntityService.set('ibizuniproduct', () => import('@/service/ibizuniproduct/ibizuniproduct-service'));
    }

    /**
     * 加载实体数据服务
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof EntityServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allEntityService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体数据服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof EntityServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const entityServiceRegister: EntityServiceRegister = new EntityServiceRegister();