import { MockAdapter } from '../mock-adapter';
const mock = MockAdapter.getInstance();

import Mock from 'mockjs'

// 获取studio链接数据
mock.onGet('./assets/json/view-config.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status,{
                "ibizsample0003stabexpview": {
            "title": "示例实体03分页导航视图",
            "caption": "示例实体03",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STabExpView",
            "viewtag": "00a0716a2029a7fe79fe03b6f74c7c90"
        },
        "ibizorderdetailsmeditview9": {
            "title": "订单明细多表单编辑视图",
            "caption": "订单明细",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSMEditView9",
            "viewtag": "02ae6ede68dce91a7a9f92070efcb2ba"
        },
        "ibizordertypepickupview": {
            "title": "订单类型数据选择视图",
            "caption": "订单类型",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypePickupView",
            "viewtag": "03c54f13883f56a08229c1a2db6a283f"
        },
        "ibizsample0018gridview": {
            "title": "示例实体04表格视图",
            "caption": "示例实体18",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0018GridView",
            "viewtag": "06f6c93b65230d180597e6bd32051447"
        },
        "ibizsample0001sf5editview": {
            "title": "默认编辑器类型",
            "caption": "默认编辑器类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF5EditView",
            "viewtag": "09663b7a4e3dce70524d1b64e02b5e2d"
        },
        "ibizsample0001sf4editview": {
            "title": "默认数据类型",
            "caption": "默认数据类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF4EditView",
            "viewtag": "0c1093afa96df2832f707495afec541e"
        },
        "ibizorderwfactionview": {
            "title": "订单工作流操作视图",
            "caption": "订单",
            "viewtype": "DEWFACTIONVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWFActionView",
            "viewtag": "0c15b18a869b229948278abd039a68d0"
        },
        "ibizorderodsp_d_wfgridview": {
            "title": "订单工作流表格视图(订单审批)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_D_WFGridView",
            "viewtag": "104b6cee4acd54ede4e4fe5fd0e28a13"
        },
        "ibizorderdetailsf1editview": {
            "title": "表单项重置项",
            "caption": "表单项重置项",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSF1EditView",
            "viewtag": "10e721a882036c8c012f35d2a6b00237"
        },
        "ibizsample0001editview": {
            "title": "IBIZSAMPLE0001编辑视图",
            "caption": "示例实体01",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001EditView",
            "viewtag": "119bfcd8d598ef01a96ed25a6ea8e5c3"
        },
        "ibizordergridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGridView",
            "viewtag": "11daa00d1185ebac3e0faec0d04fb9de"
        },
        "ibizordertabexpview": {
            "title": "订单分页导航视图",
            "caption": "订单",
            "viewtype": "DETABEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTabExpView",
            "viewtag": "1247febf206e1e0dbb4f384b4cfa565c"
        },
        "ibizordersf6gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF6GridView",
            "viewtag": "13ed6c02918e612bac45715a6f300f2f"
        },
        "ibizordertypeusr2gridview": {
            "title": "订单类型表格视图",
            "caption": "订单类型",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeUsr2GridView",
            "viewtag": "14eddc6d2c858a72c796b017959cc4ef"
        },
        "ibizorderf9editview": {
            "title": "表单动态空输入",
            "caption": "表单动态空输入",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF9EditView",
            "viewtag": "16b68282950fb352dfe27e94bda47304"
        },
        "ibizuniproducteditview": {
            "title": "统一产品编辑视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductEditView",
            "viewtag": "174534358fc2ce2d380594e39bf20f76"
        },
        "ibizorderpickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPickupView",
            "viewtag": "17770b42972334457baccfe91828bd46"
        },
        "ibizsample0003sf4editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF4EditView",
            "viewtag": "19d36909f837de28880553dc9a190922"
        },
        "index": {
            "title": "",
            "caption": "R7 Vue示例",
            "viewtype": "APPINDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "index",
            "viewtag": "1a4d3e8031d3c189cbbbb0f6c695d29d"
        },
        "ibizsample0014editview": {
            "title": "员工编辑视图",
            "caption": "员工",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0014EditView",
            "viewtag": "1c5409ef8d70e05d7906faf3ea0e5a9c"
        },
        "ibizbookeditview3": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView3",
            "viewtag": "2021cd02ec871a6984b17c9dc84c5c3a"
        },
        "ibizorderwfstartview": {
            "title": "订单工作流启动视图",
            "caption": "订单",
            "viewtype": "DEWFSTARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderWFStartView",
            "viewtag": "2640aa1ca02649c8831b43023d449945"
        },
        "ibizuniproductindexpickupdataview": {
            "title": "统一产品索引关系选择数据视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEINDEXPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductIndexPickupDataView",
            "viewtag": "26707fe400fb3e535f06015ab393793b"
        },
        "ibizorderf19editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF19EditView",
            "viewtag": "29b0f2b1cba64fab0a4c1d9e40a62778"
        },
        "ibizsample0003pickupview": {
            "title": "IBIZSAMPLE0003数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003PickupView",
            "viewtag": "2acfa7c67cff5b1f6fc0d46f6a1c06bf"
        },
        "ibizbookautogrouplistview": {
            "title": "图书列表视图（自动分组）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKAutoGroupListView",
            "viewtag": "2b42718d8fb3b4c9a01651222304445a"
        },
        "ibizbookruleseditview": {
            "title": "图书编辑视图（值规则）",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKRulesEditView",
            "viewtag": "2bf74d5d66fa6d8d38b21b090586529b"
        },
        "ibizbooktreegridexview": {
            "title": "图书树表格视图",
            "caption": "图书",
            "viewtype": "DETREEGRIDEXVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKTreeGridExView",
            "viewtag": "2ccd29eeaeded3ea5a713a19cd67a83e"
        },
        "ibizorderf13editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF13EditView",
            "viewtag": "2cd3a77cbd2aad4551b7a6a009419d52"
        },
        "ibizsample0002editview": {
            "title": "首页图表数据源编辑视图",
            "caption": "示例实体02",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002EditView",
            "viewtag": "2dd64fdd5e7303cc73090d949bc91d9b"
        },
        "ibizbookgroupbycodelistkanbanview": {
            "title": "图书看板视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGroupByCodelistKanBanView",
            "viewtag": "3041238537beef69c0f3410a1ba04c84"
        },
        "ibizordertypeeditview": {
            "title": "订单类型编辑视图",
            "caption": "订单类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeEditView",
            "viewtag": "30bdd460e697c4d94453109875060ec4"
        },
        "ibizsample0017pickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017PickupView",
            "viewtag": "3169df07474ba775203f9635eb0e9b9a"
        },
        "ibizordertypepickupgridview": {
            "title": "订单类型选择表格视图",
            "caption": "订单类型",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypePickupGridView",
            "viewtag": "31b21893ee8c5d0d9922c324daa524fd"
        },
        "ibizorderodsp_d20_wfgridview": {
            "title": "订单工作流表格视图(订单审批:审核中)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_D20_WFGridView",
            "viewtag": "3561860a1fae5554621b47824d1d3abc"
        },
        "ibizorderdetailf6editview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF6EditView",
            "viewtag": "3562240da550261dc3bb5554603bc5be"
        },
        "ibizsample0003f3treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F3TreeExpView",
            "viewtag": "36763886cbec62729dca4d4b8dad8161"
        },
        "ibizsample0017gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017GridView",
            "viewtag": "369a14f21cbff0d0fe23831aecfca7ba"
        },
        "ibizsample0018editview": {
            "title": "示例实体04编辑视图",
            "caption": "示例实体18",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0018EditView",
            "viewtag": "3730f86aa3a089df4f44f43426fc5478"
        },
        "ibizbookusr2gridview": {
            "title": "图书表格视图（自动分组）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2GridView",
            "viewtag": "39e841c85d9bbfc7ecf009c4202dbf0c"
        },
        "ibizorderseditview3": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW3",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView3",
            "viewtag": "3bbf72a3e5b59fed0dee362a9b1384a8"
        },
        "ibizordersf1gridview": {
            "title": "搜索表单内置功能",
            "caption": "搜索表单内置功能",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF1GridView",
            "viewtag": "3ebf0cd640e39a4e7efe30ec1cf32b43"
        },
        "ibizorderlinechartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderLineChartView",
            "viewtag": "41d3da0d37fb0135ace813f1ba06bd39"
        },
        "ibizcustomerpickupgridview": {
            "title": "客户选择表格视图",
            "caption": "客户",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupGridView",
            "viewtag": "460fc1d5b6f2e2012b281df34d929f3b"
        },
        "ibizsample0003streeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STreeExpView",
            "viewtag": "464b1dbf722c8dcaaa7f2cc90b8d0d8d"
        },
        "ibizbookhaspanellistview": {
            "title": "图书列表视图（嵌入面板）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKHasPanelListView",
            "viewtag": "490f607f17e7cc8ceccc77f2d0b9a70d"
        },
        "ibizorderradarchartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderRadarChartView",
            "viewtag": "491c2bc6eab0ad313d4b6f06f6a396f5"
        },
        "ibizbookusr2calendarview": {
            "title": "图书日历视图（时间轴）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2CalendarView",
            "viewtag": "4981c4ae8facb75582f8dcbc51850318"
        },
        "ibizorderdetailgridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailGridView",
            "viewtag": "4a2a1fa66c88ef36eadc4c37c6260641"
        },
        "ibizsample0017pickupgridview": {
            "title": "订单选择表格视图",
            "caption": "订单",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017PickupGridView",
            "viewtag": "4eb5a5f5e8814b94e51a68cf752d2907"
        },
        "ibizsample0017editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017EditView",
            "viewtag": "4f314340a9325fb84709f24d317afb20"
        },
        "ibizorderusr2chartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2ChartView",
            "viewtag": "502736ae9280400d7b8f74f057d363ab"
        },
        "ibizsoftwaresuitgridview9": {
            "title": "软件表格视图",
            "caption": "软件",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitGridView9",
            "viewtag": "5147eb94c8aa1cf6ad57b360e0abde28"
        },
        "ibizbookvaluerulesgridview": {
            "title": "图书表格视图（表格值规则）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKValueRulesGridView",
            "viewtag": "51dc78a9ed0e9cd37d46bec7dbc7d172"
        },
        "ibizsample0003streeexpview2": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003STreeExpView2",
            "viewtag": "53269c1ea73ad6fae5d2ac4eced7f9d1"
        },
        "ibizsoftwaresuiteditview": {
            "title": "软件编辑视图",
            "caption": "软件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitEditView",
            "viewtag": "54c2461e07dd79fdbecc2c1e3aec8096"
        },
        "ibizorderdetailseditview9": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSEditView9",
            "viewtag": "55c0b817ceaaa2894e76b510d94da24c"
        },
        "ibizsample0002pickupview": {
            "title": "首页图表数据源数据选择视图",
            "caption": "示例实体02",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002PickupView",
            "viewtag": "581e6727bc5983c238cc9990ba5fdcac"
        },
        "ibizbookmeditview9": {
            "title": "图书多表单编辑视图（多表单）",
            "caption": "图书",
            "viewtype": "DEMEDITVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKMEditView9",
            "viewtag": "59500fe075fdae44c35c88b95e64d9c8"
        },
        "ibizsample0003f4treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F4TreeExpView",
            "viewtag": "59c5d311d09a7f68f8b6962ca652374a"
        },
        "ibizsample0003pickupgridview": {
            "title": "IBIZSAMPLE0003选择表格视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003PickupGridView",
            "viewtag": "5b01a962455b84e1830e5e2f397ff9e8"
        },
        "ibizorderseditview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView",
            "viewtag": "5ccbd78fe47300a160915d6398b59604"
        },
        "ibizsample0001usr2gridview": {
            "title": "示例实体01表格视图",
            "caption": "示例实体01",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001Usr2GridView",
            "viewtag": "5e70ef78614b0b13a94605f7c22f4da4"
        },
        "ibizbookeditview2": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView2",
            "viewtag": "60be190e67cf550ae216be262fcebdf7"
        },
        "ibizsample0001sf2editview": {
            "title": "基础表单项",
            "caption": "基础表单项",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF2EditView",
            "viewtag": "658d519f1868979431e7e0da5d967e6b"
        },
        "ibizsample0003smpickupview2": {
            "title": "IBIZSAMPLE0003多项数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEMPICKUPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SMPickupView2",
            "viewtag": "668ab3660db4770c4ef6fc19c40bdc46"
        },
        "ibizbookinterfunctreeview": {
            "title": "图书树视图（树表格）",
            "caption": "图书",
            "viewtype": "DETREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncTreeView",
            "viewtag": "67eb1fee7c84df1fb44076a6e4b3fe41"
        },
        "ibizorderodsp_d10_wfgridview": {
            "title": "订单工作流表格视图(订单审批:未提交)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_D10_WFGridView",
            "viewtag": "685d47d72f4481146d9b38bd4f6f8003"
        },
        "ibizsample0003gridview": {
            "title": "IBIZSAMPLE0003表格视图",
            "caption": "示例实体03",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003GridView",
            "viewtag": "692ede21641dfdb7075ede69d7c4ad33"
        },
        "ibizordersf7editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF7EditView",
            "viewtag": "6b3607e849c8517fd7ae1cab583f7393"
        },
        "ibizbookusr5gridview": {
            "title": "图书表格视图（远程聚合）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr5GridView",
            "viewtag": "703686dd4e6aa6f55aca5d92c00d9ee3"
        },
        "ibizsample0017f10editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F10EditView",
            "viewtag": "70df82f4cd265e92e9d9add5e05a8399"
        },
        "ibizorderseditview4": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW4",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView4",
            "viewtag": "756fecec409c3a955f0cd737259d27c7"
        },
        "ibizstorageeditview": {
            "title": "存储编辑视图",
            "caption": "存储",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZStorageEditView",
            "viewtag": "75f6b59b25762a8faf7c795e94370834"
        },
        "ibizbookusr3calendarview": {
            "title": "图书日历视图（项布局面板）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3CalendarView",
            "viewtag": "794fbfb192285c60dc9ce640270d79c0"
        },
        "ibizsample0002pickupgridview": {
            "title": "首页图表数据源选择表格视图",
            "caption": "示例实体02",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002PickupGridView",
            "viewtag": "7a334494f71d4328c743657a6429ee03"
        },
        "ibizordersgridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSGridView",
            "viewtag": "7a8b6138e5893e7aba3b1a5deb3b3036"
        },
        "ibizorderbarchartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderBarChartView",
            "viewtag": "7d37165f2f535b4a6d2116188fe83d18"
        },
        "ibizsample0013pickupgridview": {
            "title": "订单明细选择表格视图",
            "caption": "订单明细",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0013PickupGridView",
            "viewtag": "8084d2af7c28ec941796eee0b810cc6e"
        },
        "ibizuniproductpickupgridview": {
            "title": "统一产品选择表格视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductPickupGridView",
            "viewtag": "80c9ae9ed04e7107ed9fc93734a447d1"
        },
        "ibizordertypeusr2editview": {
            "title": "订单类型编辑视图",
            "caption": "订单类型",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderTypeUsr2EditView",
            "viewtag": "82014278d03dfb22039740c03d2a461f"
        },
        "ibizordersf1editview": {
            "title": "编辑表单新建默认值",
            "caption": "编辑表单新建默认值",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF1EditView",
            "viewtag": "836bdb4063978b55fedd6a180d60c323"
        },
        "ibizhardwaregridview9": {
            "title": "硬件表格视图",
            "caption": "硬件",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareGridView9",
            "viewtag": "841317a57a7a8228124e41c561e01a98"
        },
        "ibizsample0003sf3editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF3EditView",
            "viewtag": "84904c93ceea3ab6551555ee20c41e27"
        },
        "ibizuniproductindexpickupview": {
            "title": "统一产品数据选择视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductIndexPickupView",
            "viewtag": "8694a4032f757bfe553eb25c85c54436"
        },
        "ibizsample0003sf1editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF1EditView",
            "viewtag": "875222727b7ab7dcaccc45808fd38b09"
        },
        "ibizorderdetailsf2editview": {
            "title": "表单项更新",
            "caption": "表单项更新",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSF2EditView",
            "viewtag": "8a3f2cc88421d9f07cbb53dd78e11495"
        },
        "ibizcustomereditview": {
            "title": "客户编辑视图",
            "caption": "客户",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerEditView",
            "viewtag": "8a4246bc438e47ec0f6f3516b9befc53"
        },
        "ibizhardwaresgridview": {
            "title": "硬件表格视图",
            "caption": "硬件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareSGridView",
            "viewtag": "8a4ccafa81445d49488874a8c7575932"
        },
        "ibizsample0017f20editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F20EditView",
            "viewtag": "9147f210be1f0751245496a40be86fad"
        },
        "ibizbookusr4gridview": {
            "title": "图书表格视图（当前页本地聚合）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4GridView",
            "viewtag": "94e6694a65d9cacb171b6e0b581216ba"
        },
        "ibizbookinterfunckanbanview": {
            "title": "图书看板视图（内置功能）",
            "caption": "图书",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncKanBanView",
            "viewtag": "98865bf786ea85b14932dd5e48a74983"
        },
        "ibizsample0015pickupgridview": {
            "title": "项目选择表格视图",
            "caption": "项目",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0015PickupGridView",
            "viewtag": "9ca3b289765416a9d9f35ab0ead5a954"
        },
        "ibizsample0014gridview": {
            "title": "员工表格视图",
            "caption": "员工",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0014GridView",
            "viewtag": "9d52aff477cf38e1d92ac24cd4a08c20"
        },
        "ibizorderpiechartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPieChartView",
            "viewtag": "9db924c804154be5b442a9737514a6f9"
        },
        "ibizorderodsp_w10_wfgridview": {
            "title": "订单工作流表格视图(订单审批:财务经理审核)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_W10_WFGridView",
            "viewtag": "9e3de0c9ef21edaba4843e642f57b14f"
        },
        "ibizordersf3editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF3EditView",
            "viewtag": "9f80ed66360fbbb9bc57c575fdd8814f"
        },
        "ibizsample0017formpickupdataview": {
            "title": "订单表单选择数据视图",
            "caption": "订单",
            "viewtype": "DEFORMPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017FormPickupDataView",
            "viewtag": "a3111cf1bb80bd7fe5652778e044b443"
        },
        "ibizsample0003spickuptreeview": {
            "title": "IBIZSAMPLE0003选择树视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPTREEVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SPickupTreeView",
            "viewtag": "a4333795f033ac3e573ec567d40ab208"
        },
        "ibizbookhaspanelkanbanview": {
            "title": "图书看板视图（嵌入视图面板）",
            "caption": "图书",
            "viewtype": "DEKANBANVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKHasPanelKanBanView",
            "viewtag": "a6cb9804bfd40d2542ae2c44e0cc3331"
        },
        "ibizsample0003editview": {
            "title": "IBIZSAMPLE0003编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003EditView",
            "viewtag": "a7f212bb3011d82e8f7798905c97eb34"
        },
        "ibizorderf8editview": {
            "title": "表单动态启用",
            "caption": "表单动态启用",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF8EditView",
            "viewtag": "a894de140705ecab2f39797d2922a3ce"
        },
        "ibizsample0017formpickupview": {
            "title": "订单数据选择视图",
            "caption": "订单",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017FormPickupView",
            "viewtag": "a8db4e54d5e2539c675cf4960853ba6e"
        },
        "ibizuniproductgridview9": {
            "title": "统一产品表格视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductGridView9",
            "viewtag": "a956bfa139d92ba395923e18d5ad301f"
        },
        "portal": {
            "title": "控制台",
            "caption": "",
            "viewtype": "APPPORTALVIEW",
            "viewmodule": "Sample",
            "viewname": "portal",
            "viewtag": "a9ddd632245daae7f66b959cda3ac935"
        },
        "ibizorderodsp_wfexpview": {
            "title": "订单工作流导航视图(订单审批)",
            "caption": "订单",
            "viewtype": "DEWFEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_WFExpView",
            "viewtag": "aa68a83577209ff0ec3864aec4e194f2"
        },
        "ibizorderodsp_d30_wfgridview": {
            "title": "订单工作流表格视图(订单审批:已通过)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_D30_WFGridView",
            "viewtag": "aaaef960c14ce3282d40f758a7dd100d"
        },
        "ibizorderpickupgridview": {
            "title": "订单选择表格视图",
            "caption": "订单",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderPickupGridView",
            "viewtag": "ab95605c916465005585241e9e74c009"
        },
        "ibizordergridview9": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderGridView9",
            "viewtag": "ac9add3724d90fba46e7298ac051fa5f"
        },
        "ibizorderf10editview": {
            "title": "表单动态显示",
            "caption": "表单动态显示",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderF10EditView",
            "viewtag": "ad37d44e57c18e4431a609968203c646"
        },
        "ibizbooklistview": {
            "title": "图书列表视图（内置功能）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKListView",
            "viewtag": "b038c48269316664e5b48380a879fd99"
        },
        "ibizsample0001sf6editview": {
            "title": "示例实体01编辑视图(编辑器扩展)",
            "caption": "示例实体01编辑视图(编辑器扩展)",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001SF6EditView",
            "viewtag": "b09ceb3081717c0ed4fe19f9986598a0"
        },
        "ibizorders2editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderS2EditView",
            "viewtag": "b1256beac1e95915b675893c61559b59"
        },
        "ibizbookcustomview": {
            "title": "图书自定义视图",
            "caption": "图书",
            "viewtype": "DECUSTOMVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKCustomView",
            "viewtag": "b1591dc4d651536bceb32b60310fd2a5"
        },
        "ibizuniproductsgridview": {
            "title": "统一产品表格视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductSGridView",
            "viewtag": "b29d930f430c127162f83753d85dd40c"
        },
        "ibizsample0001pickupgridview": {
            "title": "IBIZSAMPLE0001选择表格视图",
            "caption": "示例实体01",
            "viewtype": "DEPICKUPGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001PickupGridView",
            "viewtag": "b2c8f26f7ce8bf525754bc33a68b3f54"
        },
        "ibizbookeditview": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView",
            "viewtag": "b3429ecc4d89a02bc5f5279f1bd7f620"
        },
        "ibizorderdetailsgridview9": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW9",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSGridView9",
            "viewtag": "b4db5cb272d2da535285852bc436e9de"
        },
        "ibizordersf5gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF5GridView",
            "viewtag": "b7c0a73eb248d41eb750bbf095fa5505"
        },
        "ibizordersf2editview": {
            "title": "表单项输入提示",
            "caption": "表单项输入提示",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF2EditView",
            "viewtag": "b8ae19200ec9d4e8e588bc31e3f9bcb4"
        },
        "ibizsample0002mpickupview": {
            "title": "首页图表数据源数据多项选择视图",
            "caption": "示例实体02",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002MPickupView",
            "viewtag": "ba34a828f898eefac5a98e7b25d9aef4"
        },
        "ibizorderusr3editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr3EditView",
            "viewtag": "bafb2c128858efe856db13e44290ca6a"
        },
        "ibizbookroweditgridview": {
            "title": "图书表格视图（行编辑）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKRowEditGridView",
            "viewtag": "bc76c982dd2264463427eb57e9ed3fba"
        },
        "ibizorderodsp_w_wfgridview": {
            "title": "订单工作流表格视图(订单审批)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_W_WFGridView",
            "viewtag": "bd43538c91a9a638b36a721a43bd43a5"
        },
        "ibizorderdetaileditview": {
            "title": "订单明细编辑视图",
            "caption": "订单明细",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailEditView",
            "viewtag": "c153da73d5d5b62475f4213de51a25e0"
        },
        "ibizsoftwaresuitsgridview": {
            "title": "软件表格视图",
            "caption": "软件",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSoftwareSuitSGridView",
            "viewtag": "c8845bb5ed3853ec394b9c80eeb0416e"
        },
        "ibizsample0013pickupview": {
            "title": "订单明细数据选择视图",
            "caption": "订单明细",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0013PickupView",
            "viewtag": "ca4d303820103b229490282d1d850702"
        },
        "ibizorderdetailf6gridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailF6GridView",
            "viewtag": "d1ee943cf3137dc4d57ad59aa8c4b8cb"
        },
        "ibizorderareachartview": {
            "title": "订单图表视图",
            "caption": "订单",
            "viewtype": "DECHARTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderAreaChartView",
            "viewtag": "d1f311d51e800e95e9b10c49a8b49b5a"
        },
        "ibizsample0003mpickupview": {
            "title": "IBIZSAMPLE0003数据多项选择视图",
            "caption": "示例实体03",
            "viewtype": "DEMPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003MPickupView",
            "viewtag": "d2f9e510a23c5cd6ced43c2c89ce85b4"
        },
        "ibizorderseditview2": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSEditView2",
            "viewtag": "d3255261c8522c660c1000cd0a61c3b0"
        },
        "ibizorderusr2editview": {
            "title": "编辑表单更新默认值",
            "caption": "编辑表单更新默认值",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderUsr2EditView",
            "viewtag": "d3321077dfab8bc6b92c649e5b69daf3"
        },
        "ibizordersf4gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF4GridView",
            "viewtag": "d69d223e4d3aeb8d947ac9b9ddc60a7e"
        },
        "ibizorderodsp_d40_wfgridview": {
            "title": "订单工作流表格视图(订单审批:未通过)",
            "caption": "订单",
            "viewtype": "DEWFGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderODSP_D40_WFGridView",
            "viewtag": "d8434af36a668515f2c53743424e5e43"
        },
        "ibizbookusr4dataview": {
            "title": "图书数据视图（项布局面板）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr4DataView",
            "viewtag": "d8a6379b9ddbd161045a288aba0890b6"
        },
        "ibizordersf3gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF3GridView",
            "viewtag": "d99f9680b535dcf3ad0d0f853a8b89d9"
        },
        "ibizsample0002gridview": {
            "title": "首页图表数据源表格视图",
            "caption": "示例实体02",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0002GridView",
            "viewtag": "d9bd3192a20de0815bed3fd3d79d0cb1"
        },
        "ibizsample0003f2treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F2TreeExpView",
            "viewtag": "d9f9f0dede285235e3d0ad5101188d1e"
        },
        "ibizcpueditview": {
            "title": "处理器编辑视图",
            "caption": "处理器",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCPUEditView",
            "viewtag": "dc13e5b2e036adbcce0ced2422abb3d8"
        },
        "ibizsample0017f30editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0017F30EditView",
            "viewtag": "dd096d00060edfc66b00320c3c96ac0a"
        },
        "ibizbookusr3gridview": {
            "title": "图书表格视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3GridView",
            "viewtag": "dd8d7ffe00cabb07784f30f66a5b34da"
        },
        "ibizbookdataview": {
            "title": "图书数据视图",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKDataView",
            "viewtag": "dddefe276053bb9682b51318e96b45d6"
        },
        "ibizbookinterfunceditview": {
            "title": "图书编辑视图（内置功能）",
            "caption": "图书",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInterFuncEditView",
            "viewtag": "de9166f936946237e2d0e5367db078c2"
        },
        "ibizsample0003spickupview2": {
            "title": "IBIZSAMPLE0003数据选择视图",
            "caption": "示例实体03",
            "viewtype": "DEPICKUPVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SPickupView2",
            "viewtag": "df462fabce815005a40debffad2f43e6"
        },
        "ibizbookusr3dataview": {
            "title": "图书数据视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr3DataView",
            "viewtag": "e14e0fa8f3def77ebbcf18f1f39c0225"
        },
        "ibizorderzdytpgridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderZDYTPGridView",
            "viewtag": "e2a1c9cb077cd2c74f2f2b914fb1db84"
        },
        "ibizhardwareeditview": {
            "title": "硬件编辑视图",
            "caption": "硬件",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareEditView",
            "viewtag": "e30db3af513fb7b7bf44a8744ed5f7a4"
        },
        "ibizbookupdatedefaultgridview": {
            "title": "图书表格视图（更新默认值）",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUpdateDefaultGridView",
            "viewtag": "e53fed4d0b4dd614057f426b02115b41"
        },
        "ibizordersf4editview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF4EditView",
            "viewtag": "e54ae8e27a53b3425ac78a229a163bd5"
        },
        "ibizsample0003sf5editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF5EditView",
            "viewtag": "e57dd501c75c6933363fa245edcadbbd"
        },
        "ibizordersgridview2": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW2",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSGridView2",
            "viewtag": "e7441fa67d425df343d996c745fb5d6b"
        },
        "ibizbookganttview": {
            "title": "图书甘特视图",
            "caption": "图书",
            "viewtype": "DEGANTTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGanttView",
            "viewtag": "e92ac401e96f4e17763322eca8355c30"
        },
        "ibizbookusr2dataview": {
            "title": "图书数据视图（自动分组）",
            "caption": "图书",
            "viewtype": "DEDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKUsr2DataView",
            "viewtag": "e9b54ef29b192ecd2da05ff9570eb4d5"
        },
        "ibizsample0003f1treeexpview": {
            "title": "示例实体03树导航视图",
            "caption": "示例实体03",
            "viewtype": "DETREEEXPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003F1TreeExpView",
            "viewtag": "ea604a66caf499c70c9002a917dd1694"
        },
        "ibizsample0001gridview": {
            "title": "IBIZSAMPLE0001表格视图",
            "caption": "示例实体01",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0001GridView",
            "viewtag": "ec1fa970cf26bb42c15410168459f88d"
        },
        "ibizuniproductpickupview": {
            "title": "统一产品数据选择视图",
            "caption": "统一产品（索引主实体）",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZUNIProductPickupView",
            "viewtag": "ec6cfd868c34a036250a813b24068519"
        },
        "ibizbookgroupbycodelistlistview": {
            "title": "图书列表视图（代码表分组）",
            "caption": "图书",
            "viewtype": "DELISTVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKGroupByCodelistListView",
            "viewtag": "edca8ee67304eb78c02bbfb9e4cb11bb"
        },
        "ibizhardwareindexpickupdataview": {
            "title": "硬件索引关系选择数据视图",
            "caption": "硬件",
            "viewtype": "DEINDEXPICKUPDATAVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareIndexPickupDataView",
            "viewtag": "ef58fa6d7d250a60a7907ed895681ea1"
        },
        "ibizbookcalendarview": {
            "title": "图书日历视图（内置功能）",
            "caption": "图书",
            "viewtype": "DECALENDARVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKCalendarView",
            "viewtag": "f4c5c766fd5755b694e0401dddc4d1ad"
        },
        "ibizordereditview": {
            "title": "订单编辑视图",
            "caption": "订单",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderEditView",
            "viewtag": "f4cda6703c800c075704c5af5e58f2fc"
        },
        "ibizbookeditview4": {
            "title": "图书编辑视图",
            "caption": "图书",
            "viewtype": "DEEDITVIEW4",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKEditView4",
            "viewtag": "f54effa21e9231945eea4ff2f9b2af6f"
        },
        "ibizbookinternalfuncgridview": {
            "title": "表格内置功能",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKInternalFuncGridView",
            "viewtag": "f73da4cb47a88d3fe5b92716e0137741"
        },
        "ibizcustomerpickupview": {
            "title": "客户数据选择视图",
            "caption": "客户",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZCustomerPickupView",
            "viewtag": "f7ce60a7707de1ef9f926b3f9d5d6954"
        },
        "ibizorderdetailsgridview": {
            "title": "订单明细表格视图",
            "caption": "订单明细",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderDetailSGridView",
            "viewtag": "f90fa878f2ed0eb4e27353786b10c3f4"
        },
        "ibizordersf20gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF20GridView",
            "viewtag": "f94df735642ce85ebb2fe3816c4dc77b"
        },
        "ibizbooknewdefaultvaluegridview": {
            "title": "新建默认值",
            "caption": "图书",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZBOOKNewDefaultValueGridView",
            "viewtag": "fdb297cd4b12374534413c3053aec1b8"
        },
        "ibizsample0003sf2editview": {
            "title": "示例实体03编辑视图",
            "caption": "示例实体03",
            "viewtype": "DEEDITVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZSample0003SF2EditView",
            "viewtag": "fdb8ed39fbfea00f65416b9aaebd64e7"
        },
        "ibizhardwareindexpickupview": {
            "title": "硬件数据选择视图",
            "caption": "硬件",
            "viewtype": "DEPICKUPVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZHardwareIndexPickupView",
            "viewtag": "fe330de17a53aeeb6bd0f2a82887d1fb"
        },
        "ibizordersf15gridview": {
            "title": "订单表格视图",
            "caption": "订单",
            "viewtype": "DEGRIDVIEW",
            "viewmodule": "Sample",
            "viewname": "IBIZOrderSF15GridView",
            "viewtag": "ffedffb9c57cb200c275ba15e9100da4"
        },
        "apppanelview": {
            "title": "应用面板视图",
            "caption": "",
            "viewtype": "APPPANELVIEW",
            "viewmodule": "Ungroup",
            "viewname": "AppPanelView",
            "viewtag": "694422a6002b5b601257dbc5340c01bd"
        }
    }];
});

// 获取视图消息分组信息
mock.onGet('./assets/json/view-message-group.json').reply((config: any) => {
    let status = MockAdapter.mockStatus(config);
    return [status,{
        "VMGroup16":[
        {"tag":"ViewMsg15","position":"TOP","type":"ERROR"}
        ],
        "VMGroup31":[
        {"tag":"ViewMsg29","position":"TOP","type":"ERROR"}
        ],
        "VMGroup29":[
        {"tag":"ViewMsg31","position":"TOP","type":"ERROR"}
        ],
        "VMGroup":[
        {"tag":"ViewMsg","position":"TOP","type":"ERROR"}
        ],
        "VMGroup12":[
        {"tag":"ViewMsg11","position":"TOP","type":"ERROR"}
        ],
        "VMGroup30":[
        {"tag":"ViewMsg28","position":"TOP","type":"ERROR"}
        ],
        "VMGroup19":[
        {"tag":"ViewMsg18","position":"TOP","type":"ERROR"}
        ],
        "VMGroup6":[
        {"tag":"ViewMsg6","position":"TOP","type":"ERROR"}
        ],
        "VMGroup9":[
        {"tag":"DataViewDar","position":"TOP","type":"ERROR"}
        ],
        "VMGroup7":[
        {"tag":"ViewMsg7","position":"TOP","type":"ERROR"}
        ],
        "VMGroup24":[
        {"tag":"ViewMsg23","position":"TOP","type":"ERROR"}
        ],
        "VMGroup2":[
        {"tag":"ViewMsg2","position":"TOP","type":"ERROR"}
        ],
        "VMGroup10":[
        {"tag":"ViewMsg9","position":"TOP","type":"ERROR"}
        ],
        "VMGroup8":[
        {"tag":"ViewMsg8","position":"TOP","type":"ERROR"}
        ],
        "VMGroup18":[
        {"tag":"ViewMsg17","position":"TOP","type":"ERROR"}
        ],
        "VMGroup4":[
        {"tag":"ViewMsg4","position":"TOP","type":"ERROR"}
        ],
        "VMGroup27":[
        {"tag":"ViewMsg26","position":"TOP","type":"ERROR"}
        ],
        "VMGroup26":[
        {"tag":"ViewMsg25","position":"TOP","type":"ERROR"}
        ],
        "VMGroup32":[
        {"tag":"ViewMsg30","position":"TOP","type":"ERROR"}
        ],
        "VMGroup14":[
        {"tag":"ViewMsg13","position":"TOP","type":"ERROR"}
        ],
        "VMGroup25":[
        {"tag":"ViewMsg24","position":"TOP","type":"ERROR"}
        ],
        "VMGroup3":[
        {"tag":"ViewMsg3","position":"TOP","type":"ERROR"}
        ],
        "VMGroup5":[
        {"tag":"ViewMsg5","position":"TOP","type":"ERROR"}
        ],
        "VMGroup13":[
        {"tag":"ViewMsg12","position":"TOP","type":"ERROR"}
        ],
        "VMGroup34":[
        {"tag":"ViewMsg33","position":"TOP","type":"ERROR"}
        ],
        "VMGroup23":[
        {"tag":"ViewMsg22","position":"TOP","type":"ERROR"}
        ],
        "VMGroup17":[
        {"tag":"ViewMsg16","position":"TOP","type":"ERROR"}
        ],
        "VMGroup33":[
        {"tag":"ViewMsg32","position":"TOP","type":"ERROR"}
        ],
        "VMGroup28":[
        {"tag":"ViewMsg27","position":"TOP","type":"ERROR"}
        ],
        "VMGroup22":[
        {"tag":"ViewMsg21","position":"TOP","type":"ERROR"}
        ],
        "VMGroup20":[
        {"tag":"ViewMsg19","position":"TOP","type":"ERROR"}
        ],
        "VMGroup15":[
        {"tag":"ViewMsg14","position":"TOP","type":"ERROR"}
        ],
        "VMGroup21":[
        {"tag":"ViewMsg20","position":"TOP","type":"ERROR"}
        ],
        "VMGroup11":[
        {"tag":"ViewMsg10","position":"TOP","type":"ERROR"}
        ]
    }];
});