import ViewMessageService from '../view-message-service';
/**
 * 数据视图内置功能视图消息服务对象基类
 *
 * @export
 * @class ViewMsg6MessageServiceBase
 */
export default class ViewMsg6MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg6MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg6MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg6MessageServiceBase
     */
    public initBasicParam(){
        this.id = "FA14E673-AB67-4C52-B866-807B66E3AB19";
        this.name = "数据视图内置功能";
        this.codename = "ViewMsg6";
        this.title = "";
        this.content = "内置功能：支持快速搜索、支持快速分组搜索、支持快速搜索表单部件、支持搜索表单搜索、支持数据视图部件、视图消息和批量操作工具栏、快速操作功能栏";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg6MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}