import ViewMessageService from '../view-message-service';
/**
 * 日历部件非时间轴样式视图消息服务对象基类
 *
 * @export
 * @class ViewMsg24MessageServiceBase
 */
export default class ViewMsg24MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg24MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg24MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg24MessageServiceBase
     */
    public initBasicParam(){
        this.id = "1C7B5B06-FD69-4377-B95B-124B3779D8BF";
        this.name = "日历部件非时间轴样式";
        this.codename = "ViewMsg24";
        this.title = "";
        this.content = "非时间轴日历样式：快速搜索、快速分组搜索、搜索表单搜索、快速搜索表单部件、搜索栏搜索和快速操作工具栏、右键菜单等配置";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg24MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}