import ViewMessageService from '../view-message-service';
/**
 * 表单动态启用视图消息服务对象基类
 *
 * @export
 * @class ViewMsg22MessageServiceBase
 */
export default class ViewMsg22MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg22MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg22MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg22MessageServiceBase
     */
    public initBasicParam(){
        this.id = "D80A437E-A0AB-4A11-A503-6C4EC719BCBD";
        this.name = "表单动态启用";
        this.codename = "ViewMsg22";
        this.title = "";
        this.content = "表单动态启用：开关打开时，启用文本框";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg22MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}