import ViewMessageService from '../view-message-service';
/**
 * 表单项更新视图消息服务对象基类
 *
 * @export
 * @class ViewMsg27MessageServiceBase
 */
export default class ViewMsg27MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg27MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg27MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg27MessageServiceBase
     */
    public initBasicParam(){
        this.id = "E7036F63-2FDE-42C5-A85A-806CDD320E37";
        this.name = "表单项更新";
        this.codename = "ViewMsg27";
        this.title = "";
        this.content = "本示例展示表单的表单项更新功能；展示内容包含通过商品获取单位和单价";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg27MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}