import ViewMessageService from '../view-message-service';
/**
 * 表格聚合（本页聚合）视图消息服务对象基类
 *
 * @export
 * @class ViewMsg15MessageServiceBase
 */
export default class ViewMsg15MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg15MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg15MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg15MessageServiceBase
     */
    public initBasicParam(){
        this.id = "1FBAE147-F355-498E-8417-2167648EB362";
        this.name = "表格聚合（本页聚合）";
        this.codename = "ViewMsg15";
        this.title = "";
        this.content = "表格聚合：本页聚合";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg15MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}