import ViewMessageService from '../view-message-service';
/**
 * 自动分组视图消息服务对象基类
 *
 * @export
 * @class ViewMsg7MessageServiceBase
 */
export default class ViewMsg7MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg7MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg7MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg7MessageServiceBase
     */
    public initBasicParam(){
        this.id = "12EDBAFE-47E3-444C-8AEB-EF84C55646E0";
        this.name = "自动分组";
        this.codename = "ViewMsg7";
        this.title = "";
        this.content = "自动分组：分组属性为作者";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg7MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}