import ViewMessageService from '../view-message-service';
/**
 * 多表单编辑视图消息服务对象基类
 *
 * @export
 * @class ViewMsg31MessageServiceBase
 */
export default class ViewMsg31MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg31MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg31MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg31MessageServiceBase
     */
    public initBasicParam(){
        this.id = "BABA99D6-3DB7-43EA-8628-0643DAB34E62";
        this.name = "多表单编辑";
        this.codename = "ViewMsg31";
        this.title = "";
        this.content = "多表单编辑：该视图为图书多表单编辑视图。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg31MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}