import ViewMessageService from '../view-message-service';
/**
 * 列表嵌入面板视图消息视图消息服务对象基类
 *
 * @export
 * @class ViewMsg12MessageServiceBase
 */
export default class ViewMsg12MessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  ViewMsg12MessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  ViewMsg12MessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof ViewMsg12MessageServiceBase
     */
    public initBasicParam(){
        this.id = "DF8710A3-8464-45AC-BD65-5749FEA8BBAF";
        this.name = "列表嵌入面板视图消息";
        this.codename = "ViewMsg12";
        this.title = "";
        this.content = "此视图用于展示列表嵌入面板功能。面板内容用户可自定义。";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof ViewMsg12MessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}