import ViewMessageService from '../view-message-service';
/**
 * 数据视图（项布局面板）视图消息服务对象基类
 *
 * @export
 * @class DataViewDarMessageServiceBase
 */
export default class DataViewDarMessageServiceBase extends ViewMessageService {


    /**
     * Creates an instance of  DataViewDarMessageServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  DataViewDarMessageServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础参数
     * 
     * @memberof DataViewDarMessageServiceBase
     */
    public initBasicParam(){
        this.id = "DBDA15AA-C0C3-4BB0-95DF-AD8AAD082352";
        this.name = "数据视图（项布局面板）";
        this.codename = "DataViewDar";
        this.title = "";
        this.content = "数据视图：配置项布局面板";
        this.closeMode = 0;
        this.position = "TOP";
        this.type = "error";
        this.isEnableRemove = false;
        this.order = 1;
        this.dynamicMode = "STATIC";
        this.hasMessageTemp = false;
        this.messageType = "TEXT";
    }

    /**
     * 转化消息模板标题和内容
     *      
     * @target {*} target 返回目标数据
     * @param {*} context 应用上下文
     * @param {*} viewparam 视图参数
     * @param {*} item 源数据
     * 
     * @memberof DataViewDarMessageServiceBase
     */
    public translateMessageTemp(target:any,context:any,viewparam:any,item?:any){
        if(this.hasMessageTemp && Object.is(this.messageType,"HTML")){
            Object.assign(target,{title:``});
            Object.assign(target,{content:``});
        }
        if(this.hasMessageTemp && Object.is(this.messageType,"TEXT")){
            Object.assign(target,{title:""});
            Object.assign(target,{content:""});
        }
    }

}