package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
import cn.ibizlab.core.sample.service.IIBIZOrderTypeService;
import cn.ibizlab.core.sample.filter.IBIZOrderTypeSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单类型" })
@RestController("DemoAPI-ibizordertype")
@RequestMapping("")
public class IBIZOrderTypeResource {

    @Autowired
    public IIBIZOrderTypeService ibizordertypeService;

    @Autowired
    @Lazy
    public IBIZOrderTypeMapping ibizordertypeMapping;

    @PreAuthorize("hasPermission(this.ibizordertypeMapping.toDomain(#ibizordertypedto),'DemoSys-IBIZOrderType-Create')")
    @ApiOperation(value = "新建订单类型", tags = {"订单类型" },  notes = "新建订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes")
    public ResponseEntity<IBIZOrderTypeDTO> create(@Validated @RequestBody IBIZOrderTypeDTO ibizordertypedto) {
        IBIZOrderType domain = ibizordertypeMapping.toDomain(ibizordertypedto);
		ibizordertypeService.create(domain);
        IBIZOrderTypeDTO dto = ibizordertypeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizordertypeMapping.toDomain(#ibizordertypedtos),'DemoSys-IBIZOrderType-Create')")
    @ApiOperation(value = "批量新建订单类型", tags = {"订单类型" },  notes = "批量新建订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderTypeDTO> ibizordertypedtos) {
        ibizordertypeService.createBatch(ibizordertypeMapping.toDomain(ibizordertypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizordertype" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizordertypeService.get(#ibizordertype_id),'DemoSys-IBIZOrderType-Update')")
    @ApiOperation(value = "更新订单类型", tags = {"订单类型" },  notes = "更新订单类型")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizordertypes/{ibizordertype_id}")
    public ResponseEntity<IBIZOrderTypeDTO> update(@PathVariable("ibizordertype_id") String ibizordertype_id, @RequestBody IBIZOrderTypeDTO ibizordertypedto) {
		IBIZOrderType domain  = ibizordertypeMapping.toDomain(ibizordertypedto);
        domain .setIbizordertypeid(ibizordertype_id);
		ibizordertypeService.update(domain );
		IBIZOrderTypeDTO dto = ibizordertypeMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizordertypeService.getIbizordertypeByEntities(this.ibizordertypeMapping.toDomain(#ibizordertypedtos)),'DemoSys-IBIZOrderType-Update')")
    @ApiOperation(value = "批量更新订单类型", tags = {"订单类型" },  notes = "批量更新订单类型")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizordertypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderTypeDTO> ibizordertypedtos) {
        ibizordertypeService.updateBatch(ibizordertypeMapping.toDomain(ibizordertypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizordertypeService.get(#ibizordertype_id),'DemoSys-IBIZOrderType-Remove')")
    @ApiOperation(value = "删除订单类型", tags = {"订单类型" },  notes = "删除订单类型")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizordertypes/{ibizordertype_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizordertype_id") String ibizordertype_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizordertypeService.remove(ibizordertype_id));
    }

    @PreAuthorize("hasPermission(this.ibizordertypeService.getIbizordertypeByIds(#ids),'DemoSys-IBIZOrderType-Remove')")
    @ApiOperation(value = "批量删除订单类型", tags = {"订单类型" },  notes = "批量删除订单类型")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizordertypes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizordertypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizordertypeMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderType-Get')")
    @ApiOperation(value = "获取订单类型", tags = {"订单类型" },  notes = "获取订单类型")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizordertypes/{ibizordertype_id}")
    public ResponseEntity<IBIZOrderTypeDTO> get(@PathVariable("ibizordertype_id") String ibizordertype_id) {
        IBIZOrderType domain = ibizordertypeService.get(ibizordertype_id);
        IBIZOrderTypeDTO dto = ibizordertypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取订单类型草稿", tags = {"订单类型" },  notes = "获取订单类型草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizordertypes/getdraft")
    public ResponseEntity<IBIZOrderTypeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizordertypeMapping.toDto(ibizordertypeService.getDraft(new IBIZOrderType())));
    }

    @ApiOperation(value = "检查订单类型", tags = {"订单类型" },  notes = "检查订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZOrderTypeDTO ibizordertypedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizordertypeService.checkKey(ibizordertypeMapping.toDomain(ibizordertypedto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-ResetCodeList-all')")
    @ApiOperation(value = "", tags = {"订单类型" },  notes = "")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes/{ibizordertype_id}/resetcodelist")
    public ResponseEntity<IBIZOrderTypeDTO> resetCodeList(@PathVariable("ibizordertype_id") String ibizordertype_id, @RequestBody IBIZOrderTypeDTO ibizordertypedto) {
        IBIZOrderType domain = ibizordertypeMapping.toDomain(ibizordertypedto);
        domain.setIbizordertypeid(ibizordertype_id);
        domain = ibizordertypeService.resetCodeList(domain);
        ibizordertypedto = ibizordertypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizordertypedto);
    }

    @PreAuthorize("hasPermission(this.ibizordertypeMapping.toDomain(#ibizordertypedto),'DemoSys-IBIZOrderType-Save')")
    @ApiOperation(value = "保存订单类型", tags = {"订单类型" },  notes = "保存订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZOrderTypeDTO ibizordertypedto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizordertypeService.save(ibizordertypeMapping.toDomain(ibizordertypedto)));
    }

    @PreAuthorize("hasPermission(this.ibizordertypeMapping.toDomain(#ibizordertypedtos),'DemoSys-IBIZOrderType-Save')")
    @ApiOperation(value = "批量保存订单类型", tags = {"订单类型" },  notes = "批量保存订单类型")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizordertypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderTypeDTO> ibizordertypedtos) {
        ibizordertypeService.saveBatch(ibizordertypeMapping.toDomain(ibizordertypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderType-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单类型" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizordertypes/fetchdefault")
	public ResponseEntity<List<IBIZOrderTypeDTO>> fetchDefault(IBIZOrderTypeSearchContext context) {
        Page<IBIZOrderType> domains = ibizordertypeService.searchDefault(context) ;
        List<IBIZOrderTypeDTO> list = ibizordertypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderType-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderType-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单类型" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizordertypes/searchdefault")
	public ResponseEntity<Page<IBIZOrderTypeDTO>> searchDefault(@RequestBody IBIZOrderTypeSearchContext context) {
        Page<IBIZOrderType> domains = ibizordertypeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizordertypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

