package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
import cn.ibizlab.core.sample.service.IIBIZOrderDetailService;
import cn.ibizlab.core.sample.filter.IBIZOrderDetailSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"订单明细" })
@RestController("DemoAPI-ibizorderdetail")
@RequestMapping("")
public class IBIZOrderDetailResource {

    @Autowired
    public IIBIZOrderDetailService ibizorderdetailService;

    @Autowired
    @Lazy
    public IBIZOrderDetailMapping ibizorderdetailMapping;

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "新建订单明细", tags = {"订单明细" },  notes = "新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails")
    public ResponseEntity<IBIZOrderDetailDTO> create(@Validated @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
		ibizorderdetailService.create(domain);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Create')")
    @ApiOperation(value = "批量新建订单明细", tags = {"订单明细" },  notes = "批量新建订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.createBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CreateTemp-all')")
    @ApiOperation(value = "CreateTemp", tags = {"订单明细" },  notes = "CreateTemp")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/{ibizorderdetail_id}/createtemp")
    public ResponseEntity<IBIZOrderDetailDTO> createTemp(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.createTemp(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CreateTempMajor-all')")
    @ApiOperation(value = "CreateTempMajor", tags = {"订单明细" },  notes = "CreateTempMajor")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/{ibizorderdetail_id}/createtempmajor")
    public ResponseEntity<IBIZOrderDetailDTO> createTempMajor(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.createTempMajor(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @VersionCheck(entity = "ibizorderdetail" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "更新订单明细", tags = {"订单明细" },  notes = "更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> update(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
		IBIZOrderDetail domain  = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain .setIbizorderdetailid(ibizorderdetail_id);
		ibizorderdetailService.update(domain );
		IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByEntities(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos)),'DemoSys-IBIZOrderDetail-Update')")
    @ApiOperation(value = "批量更新订单明细", tags = {"订单明细" },  notes = "批量更新订单明细")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.updateBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-UpdateTemp-all')")
    @ApiOperation(value = "UpdateTemp", tags = {"订单明细" },  notes = "UpdateTemp")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/{ibizorderdetail_id}/updatetemp")
    public ResponseEntity<IBIZOrderDetailDTO> updateTemp(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.updateTemp(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-UpdateTempMajor-all')")
    @ApiOperation(value = "UpdateTempMajor", tags = {"订单明细" },  notes = "UpdateTempMajor")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizorderdetails/{ibizorderdetail_id}/updatetempmajor")
    public ResponseEntity<IBIZOrderDetailDTO> updateTempMajor(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.updateTempMajor(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.get(#ibizorderdetail_id),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "删除订单明细", tags = {"订单明细" },  notes = "删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.remove(ibizorderdetail_id));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailService.getIbizorderdetailByIds(#ids),'DemoSys-IBIZOrderDetail-Remove')")
    @ApiOperation(value = "批量删除订单明细", tags = {"订单明细" },  notes = "批量删除订单明细")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizorderdetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-RemoveTemp-all')")
    @ApiOperation(value = "RemoveTemp", tags = {"订单明细" },  notes = "RemoveTemp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/{ibizorderdetail_id}/removetemp")
    public ResponseEntity<IBIZOrderDetailDTO> removeTemp(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.removeTemp(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-RemoveTempMajor-all')")
    @ApiOperation(value = "RemoveTempMajor", tags = {"订单明细" },  notes = "RemoveTempMajor")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizorderdetails/{ibizorderdetail_id}/removetempmajor")
    public ResponseEntity<IBIZOrderDetailDTO> removeTempMajor(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.removeTempMajor(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PostAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(returnObject.body),'DemoSys-IBIZOrderDetail-Get')")
    @ApiOperation(value = "获取订单明细", tags = {"订单明细" },  notes = "获取订单明细")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}")
    public ResponseEntity<IBIZOrderDetailDTO> get(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id) {
        IBIZOrderDetail domain = ibizorderdetailService.get(ibizorderdetail_id);
        IBIZOrderDetailDTO dto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetTemp-all')")
    @ApiOperation(value = "GetTemp", tags = {"订单明细" },  notes = "GetTemp")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}/gettemp")
    public ResponseEntity<IBIZOrderDetailDTO> getTemp(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.getTemp(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetTempMajor-all')")
    @ApiOperation(value = "GetTempMajor", tags = {"订单明细" },  notes = "GetTempMajor")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}/gettempmajor")
    public ResponseEntity<IBIZOrderDetailDTO> getTempMajor(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.getTempMajor(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @ApiOperation(value = "获取订单明细草稿", tags = {"订单明细" },  notes = "获取订单明细草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/getdraft")
    public ResponseEntity<IBIZOrderDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailMapping.toDto(ibizorderdetailService.getDraft(new IBIZOrderDetail())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetDraftTemp-all')")
    @ApiOperation(value = "GetDraftTemp", tags = {"订单明细" },  notes = "GetDraftTemp")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/getdrafttemp")
    public ResponseEntity<IBIZOrderDetailDTO> getDraftTemp() {
        IBIZOrderDetail domain =new IBIZOrderDetail();
        domain = ibizorderdetailService.getDraftTemp(domain);
        IBIZOrderDetailDTO ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetDraftTempMajor-all')")
    @ApiOperation(value = "GetDraftTempMajor", tags = {"订单明细" },  notes = "GetDraftTempMajor")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}/getdrafttempmajor")
    public ResponseEntity<IBIZOrderDetailDTO> getDraftTempMajor(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.getDraftTempMajor(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @ApiOperation(value = "检查订单明细", tags = {"订单明细" },  notes = "检查订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.checkKey(ibizorderdetailMapping.toDomain(ibizorderdetaildto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-CountMoney-all')")
    @ApiOperation(value = "统计金额", tags = {"订单明细" },  notes = "统计金额")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/{ibizorderdetail_id}/countmoney")
    public ResponseEntity<IBIZOrderDetailDTO> countMoney(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.countMoney(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-GetUnitAndPrice-all')")
    @ApiOperation(value = "", tags = {"订单明细" },  notes = "")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizorderdetails/{ibizorderdetail_id}/getunitandprice")
    public ResponseEntity<IBIZOrderDetailDTO> getUnitAndPrice(@PathVariable("ibizorderdetail_id") String ibizorderdetail_id, @RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        IBIZOrderDetail domain = ibizorderdetailMapping.toDomain(ibizorderdetaildto);
        domain.setIbizorderdetailid(ibizorderdetail_id);
        domain = ibizorderdetailService.getUnitAndPrice(domain);
        ibizorderdetaildto = ibizorderdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetaildto);
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildto),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "保存订单明细", tags = {"订单明细" },  notes = "保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZOrderDetailDTO ibizorderdetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizorderdetailService.save(ibizorderdetailMapping.toDomain(ibizorderdetaildto)));
    }

    @PreAuthorize("hasPermission(this.ibizorderdetailMapping.toDomain(#ibizorderdetaildtos),'DemoSys-IBIZOrderDetail-Save')")
    @ApiOperation(value = "批量保存订单明细", tags = {"订单明细" },  notes = "批量保存订单明细")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizorderdetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZOrderDetailDTO> ibizorderdetaildtos) {
        ibizorderdetailService.saveBatch(ibizorderdetailMapping.toDomain(ibizorderdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取测试明细打印", tags = {"订单明细" } ,notes = "获取测试明细打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/fetchcsmxdy")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchCSMXDY(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchCSMXDY-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询测试明细打印", tags = {"订单明细" } ,notes = "查询测试明细打印")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchcsmxdy")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchCSMXDY(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchCSMXDY(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"订单明细" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/fetchdefault")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchDefault(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"订单明细" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchdefault")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchDefault(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取查询订单明细中产品数量", tags = {"订单明细" } ,notes = "获取查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/fetchlogic_0007")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchLOGIC_0007(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchLOGIC_0007-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询查询订单明细中产品数量", tags = {"订单明细" } ,notes = "查询查询订单明细中产品数量")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchlogic_0007")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchLOGIC_0007(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchLOGIC_0007(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "获取x", tags = {"订单明细" } ,notes = "获取x")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/fetchx")
	public ResponseEntity<List<IBIZOrderDetailDTO>> fetchX(IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
        List<IBIZOrderDetailDTO> list = ibizorderdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZOrderDetail-searchX-all') and hasPermission(#context,'DemoSys-IBIZOrderDetail-Get')")
	@ApiOperation(value = "查询x", tags = {"订单明细" } ,notes = "查询x")
    @RequestMapping(method= RequestMethod.POST , value="/ibizorderdetails/searchx")
	public ResponseEntity<Page<IBIZOrderDetailDTO>> searchX(@RequestBody IBIZOrderDetailSearchContext context) {
        Page<IBIZOrderDetail> domains = ibizorderdetailService.searchX(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizorderdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

