import qs from 'qs';
import { MockAdapter } from '@/mock/mock-adapter';
const mock = MockAdapter.getInstance();

// 模拟数据
const mockDatas: Array<any> = [
];


//getwflink
mock.onGet(new RegExp(/^\/wfcore\/demosys-app-web\/ibizorders\/[a-zA-Z0-9\-\;]+\/usertasks\/[a-zA-Z0-9\-\;]+\/ways$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: getwflink");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status,[
        {"sequenceFlowId":"dfdsfdsfdsfdsfds","sequenceFlowName":"同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddlfldldfldsfds","refViewKey":""},
        {"sequenceFlowId":"ddssdfdfdfdfsfdf","sequenceFlowName":"不同意",
         "taskId":"aaaaddddccccddddd","processDefinitionKey":"support-workorders-approve-v1",
         "processInstanceId":"ddfdsldlfdlldsf","refViewKey":"workorder_ltform_editview"}
        ]];
});

// getwfstep
mock.onGet(new RegExp(/^\/wfcore\/demosys-app-web\/ibizorders\/process-definitions-nodes$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: getwfstep");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, [
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-dfdfd",
        "userTaskName":"待审",
        "cnt":0,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"
        },
        {"userTaskId":"sddfddfd-dfdf-fdfd-fdf-87927",
        "userTaskName":"待分配",
        "cnt":3,
        "processDefinitionKey":"support-workorders-approve-v1",
        "processDefinitionName":"工单审批流程v1"}
        ]];
});

// createBatch
mock.onPost(new RegExp(/^\/ibizorders\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: createBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// updateBatch
mock.onPut(new RegExp(/^\/ibizorders\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: updateBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});

// removeBatch
mock.onDelete(new RegExp(/^\/ibizorders\/batch$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: removeBatch");
    console.table({url:config.url, method: config.method, data:config.data});
    console.groupEnd();
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, {}];
    }
    return [status, {}];
});


// Select
mock.onPost(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/select$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Select");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/select$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items);
    console.groupEnd();
    console.groupEnd();
    return [status, _items];
});
        
// SelectTemp
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/selecttemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: SelectTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/selecttemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Create
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Create");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas[0]);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas[0]];
});
        
// CreateTemp
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/createtemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: CreateTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/createtemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// CreateTempMajor
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/createtempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: CreateTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/createtempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Update
mock.onPut(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Update");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// UpdateTemp
mock.onPut(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/updatetemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: UpdateTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/updatetemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// UpdateTempMajor
mock.onPut(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/updatetempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: UpdateTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/updatetempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});

// GetDraft
mock.onGet(new RegExp(/^\/ibizorders\/getdraft$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: GetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraft
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});

// GetDraftTemp
mock.onGet(new RegExp(/^\/ibizorders\/getdrafttemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: GetDraftTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    // GetDraftTemp
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table({});
    console.groupEnd();
    console.groupEnd();
    return [status, {}];
});
        
// BUIAction
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/buiaction$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: BUIAction");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/buiaction$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// CheckKey
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/checkkey$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: CheckKey");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/checkkey$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// Save
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/save$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Save");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/save$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchCSDY
mock.onGet(new RegExp(/^\/ibizorders\/fetchcsdy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchCSDY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchCSDY
mock.onGet(new RegExp(/^\/ibizorders\/fetchcsdy(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchCSDY");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempCSDY
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempcsdy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempCSDY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempcsdy$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchCurState30
mock.onGet(new RegExp(/^\/ibizorders\/fetchcurstate30$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchCurState30");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchCurState30
mock.onGet(new RegExp(/^\/ibizorders\/fetchcurstate30(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchCurState30");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempCurState30
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempcurstate30$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempCurState30");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempcurstate30$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchDDJETJBB
mock.onGet(new RegExp(/^\/ibizorders\/fetchddjetjbb$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDDJETJBB");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDDJETJBB
mock.onGet(new RegExp(/^\/ibizorders\/fetchddjetjbb(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDDJETJBB");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempDDJETJBB
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempddjetjbb$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempDDJETJBB");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempddjetjbb$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchDDReport
mock.onGet(new RegExp(/^\/ibizorders\/fetchddreport$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDDReport");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDDReport
mock.onGet(new RegExp(/^\/ibizorders\/fetchddreport(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDDReport");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempDDReport
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempddreport$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempDDReport");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempddreport$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchDYDDMXSJY
mock.onGet(new RegExp(/^\/ibizorders\/fetchdyddmxsjy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDYDDMXSJY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDYDDMXSJY
mock.onGet(new RegExp(/^\/ibizorders\/fetchdyddmxsjy(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDYDDMXSJY");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempDYDDMXSJY
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempdyddmxsjy$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempDYDDMXSJY");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempdyddmxsjy$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchDefault
mock.onGet(new RegExp(/^\/ibizorders\/fetchdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchDefault
mock.onGet(new RegExp(/^\/ibizorders\/fetchdefault(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempDefault
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempdefault$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempDefault");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempdefault$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchEchartsDefaultDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchechartsdefaultdatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchEchartsDefaultDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchEchartsDefaultDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchechartsdefaultdatasource(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchEchartsDefaultDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempEchartsDefaultDataSource
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempechartsdefaultdatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempEchartsDefaultDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempechartsdefaultdatasource$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchGaugeDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchgaugedatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchGaugeDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchGaugeDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchgaugedatasource(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchGaugeDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempGaugeDataSource
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempgaugedatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempGaugeDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempgaugedatasource$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchGaugeDataSourceByTime
mock.onGet(new RegExp(/^\/ibizorders\/fetchgaugedatasourcebytime$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchGaugeDataSourceByTime");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchGaugeDataSourceByTime
mock.onGet(new RegExp(/^\/ibizorders\/fetchgaugedatasourcebytime(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchGaugeDataSourceByTime");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempGaugeDataSourceByTime
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempgaugedatasourcebytime$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempGaugeDataSourceByTime");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempgaugedatasourcebytime$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchLOGIC_22
mock.onGet(new RegExp(/^\/ibizorders\/fetchlogic_22$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchLOGIC_22");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchLOGIC_22
mock.onGet(new RegExp(/^\/ibizorders\/fetchlogic_22(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchLOGIC_22");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempLOGIC_22
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtemplogic_22$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempLOGIC_22");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtemplogic_22$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchRadarDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchradardatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchRadarDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchRadarDataSource
mock.onGet(new RegExp(/^\/ibizorders\/fetchradardatasource(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchRadarDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempRadarDataSource
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempradardatasource$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempRadarDataSource");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempradardatasource$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchSHZOrder
mock.onGet(new RegExp(/^\/ibizorders\/fetchshzorder$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchSHZOrder");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchSHZOrder
mock.onGet(new RegExp(/^\/ibizorders\/fetchshzorder(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchSHZOrder");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempSHZOrder
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempshzorder$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempSHZOrder");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempshzorder$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchState10
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate10$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState10");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchState10
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate10(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState10");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempState10
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempstate10$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempState10");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempstate10$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchState30
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate30$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState30");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchState30
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate30(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState30");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempState30
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempstate30$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempState30");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempstate30$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchState40
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate40$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState40");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchState40
mock.onGet(new RegExp(/^\/ibizorders\/fetchstate40(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchState40");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempState40
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempstate40$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempState40");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempstate40$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
    
// FetchXECX
mock.onGet(new RegExp(/^\/ibizorders\/fetchxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchXECX");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(mockDatas);
    console.groupEnd();
    console.groupEnd();
    return [status, mockDatas ? mockDatas : []];
});

// FetchXECX
mock.onGet(new RegExp(/^\/ibizorders\/fetchxecx(\?[\w-./?%&=,]*)*$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchXECX");
    console.table({url:config.url, method: config.method, data:config.data});
    if(config.url.includes('page')){
        let url = config.url.split('?')[1];
        let params  =  qs.parse(url);
        Object.assign(config, params);
    }
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }
    let total = mockDatas.length;
    let records: Array<any> = [];
    if(!config.page || !config.size){
        records = mockDatas;
    }else{
        if((config.page-1)*config.size < total){
          records = mockDatas.slice(config.page,config.size);
        }
    }
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(records ?  records : []);
    console.groupEnd();
    console.groupEnd();
    return [status, records ?  records : []];
});
        
// FetchTempXECX
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FetchTempXECX");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterUpdate
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterUpdate");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterSearch
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterSearch");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterGet
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterGet");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterCreate
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterCreate");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterGetDraft
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterGetDraft");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterRemove
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterRemove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});
        
// FilterFetch
mock.onPost(new RegExp(/^\/ibizorders\/?([a-zA-Z0-9\-\;]{0,35})\/fetchtempxecx$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: FilterFetch");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/fetchtempxecx$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    //let items = mockDatas ? mockDatas : [];
    //let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
      let data = JSON.parse(config.data);
    mockDatas.forEach((item)=>{
        if(item['ibizorderid'] == tempValue['ibizorderid'] ){
            for(let value in data){
              if(item.hasOwnProperty(value)){
                  item[value] = data[value];
              }
            }
        }
    })
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(data);
    console.groupEnd();
    console.groupEnd();
    return [status, data];
});


// Remove
mock.onDelete(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Remove");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// RemoveTemp
mock.onDelete(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/removetemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: RemoveTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/removetemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// RemoveTempMajor
mock.onDelete(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/removetempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: RemoveTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/removetempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// Get
mock.onGet(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: Get");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetTemp
mock.onGet(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/gettemp$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: GetTemp");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/gettemp$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetTempMajor
mock.onGet(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/gettempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: GetTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/gettempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});

// GetDraftTempMajor
mock.onGet(new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/getdrafttempmajor$/)).reply((config: any) => {
    console.groupCollapsed("实体:ibizorder 方法: GetDraftTempMajor");
    console.table({url:config.url, method: config.method, data:config.data});
    let status = MockAdapter.mockStatus(config);
    if (status !== 200) {
        return [status, null];
    }    
    const paramArray:Array<any> = ['ibizorderid'];
    const matchArray:any = new RegExp(/^\/ibizorders\/([a-zA-Z0-9\-\;]{1,35})\/getdrafttempmajor$/).exec(config.url);
    let tempValue: any = {};
    if(matchArray && matchArray.length >1 && paramArray && paramArray.length >0){
        paramArray.forEach((item: any, index: number) => {
            Object.defineProperty(tempValue, item, {
                enumerable: true,
                value: matchArray[index + 1]
            });
        });
    }
    let items = mockDatas ? mockDatas : [];
    let _items = items.find((item: any) => Object.is(item.ibizorderid, tempValue.ibizorderid));
    console.groupCollapsed("response数据  status: "+status+" data: ");
    console.table(_items?_items:{});
    console.groupEnd();
    console.groupEnd();
    return [status, _items?_items:{}];
});
