import { ILogicNode } from "@/interface/logic";
import { UIActionContext } from "@/logic/ui-logic";

/**
 * 打开语雀文档
 *
 * @export
 * @class OpenYuQueUILogicBase
 */
export default class OpenYuQueUILogicBase {

    /**
     * Creates an instance of  OpenYuQueBase.
     * 
     * @param {*} [opts={}]
     * @memberof OpenYuQueUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 开始节点
     *
     * @protected
     * @type {string}
     * @memberof OpenYuQueUILogicBase
     */
    protected readonly startLogicNode: string = 'Begin';

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof OpenYuQueUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: false,
            lastReturnParam: false
        },
    ];

    /**
     * 逻辑节点
     *
     * @protected
     * @type {ILogicNode[]}
     * @memberof OpenYuQueUILogicBase
     */
    protected logicNodes: ILogicNode[] = [
        { codeName: 'Begin', name: '开始', logicNodeType: 'BEGIN', logicLinks: [ { name: '连接名称', dstLogicNode: 'DEUIACTION1', } ] },
        { codeName: 'END1', name: '结束', logicNodeType: 'END', returnType: 'NONEVALUE', returnRawValue: '', },
        { codeName: 'DEUIACTION1', name: '界面行为', logicNodeType: 'DEUIACTION', dstParam: 'Default', logicLinks: [ { name: '连接名称', dstLogicNode: 'END1', } ] },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof OpenYuQueUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof OpenYuQueUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            const startNode = this.logicNodes.find((logicNode: ILogicNode) => logicNode.codeName === this.startLogicNode);
            if (!startNode) {
                throw new Error('没有开始节点');
            }
            await this.executeNode(startNode, actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @memberof OpenYuQueUILogicBase
     */
    executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            switch (logicNode.logicNodeType) {
                case 'BEGIN':
                    console.log(111, '执行开始节点');
                    break;
                case 'END':
                    console.log(111, '执行结束节点');
                    break;
            }
        } catch (error: any) {

        }
    }


}