import { ILogicNode } from "@/interface/logic";
import { UIActionContext } from "@/logic/ui-logic";

/**
 * 自定义表格数据加载
 *
 * @export
 * @class GridViewLoadUILogicBase
 */
export default class GridViewLoadUILogicBase {

    /**
     * Creates an instance of  GridViewLoadBase.
     * 
     * @param {*} [opts={}]
     * @memberof GridViewLoadUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 开始节点
     *
     * @protected
     * @type {string}
     * @memberof GridViewLoadUILogicBase
     */
    protected readonly startLogicNode: string = 'Begin';

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof GridViewLoadUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '当前视图参数',
            codeName: 'viewParam',
            default: false,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: false,
            lastReturnParam: false
        },
        {
            name: '当前视图对象',
            codeName: 'view',
            default: false,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: true,
            lastReturnParam: false
        },
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: false,
            lastReturnParam: false
        },
        {
            name: '当前表格',
            codeName: 'grid',
            default: false,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: false,
            lastReturnParam: false
        },
        {
            name: '当前搜索表单',
            codeName: 'searchForm',
            default: false,
            navContextParam: false,
            navViewParamParam: false,
            activeContainerParam: false,
            activeCtrlParam: false,
            activeViewParam: false,
            lastReturnParam: false
        },
    ];

    /**
     * 逻辑节点
     *
     * @protected
     * @type {ILogicNode[]}
     * @memberof GridViewLoadUILogicBase
     */
    protected logicNodes: ILogicNode[] = [
        { codeName: 'Begin', name: '开始', logicNodeType: 'BEGIN', logicLinks: [ { name: '连接名称', dstLogicNode: 'BINDPARAM1', } ] },
        { codeName: 'BINDPARAM1', name: '绑定当前搜索表单', logicNodeType: 'BINDPARAM', dstParam: 'searchForm', srcParam: 'view', srcFieldName: 'searchForm', logicLinks: [ { name: '连接名称', dstLogicNode: 'VIEWCTRLINVOKE1', } ] },
        { codeName: 'VIEWCTRLINVOKE1', name: '视图部件调用', logicNodeType: 'VIEWCTRLINVOKE', dstParam: 'viewParam', srcParam: 'searchForm', logicLinks: [ { name: '连接名称', dstLogicNode: 'VIEWCTRLINVOKE2', } ] },
        { codeName: 'END1', name: '结束', logicNodeType: 'END', returnType: 'NONEVALUE', returnRawValue: '', },
        { codeName: 'VIEWCTRLINVOKE2', name: '视图部件调用', logicNodeType: 'VIEWCTRLINVOKE', dstParam: 'viewParam', srcParam: 'grid', logicLinks: [ { name: '连接名称', dstLogicNode: 'END1', } ] },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof GridViewLoadUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof GridViewLoadUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            const startNode = this.logicNodes.find((logicNode: ILogicNode) => logicNode.codeName === this.startLogicNode);
            if (!startNode) {
                throw new Error('没有开始节点');
            }
            await this.executeNode(startNode, actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 执行节点
     *
     * @param {ILogicNode} logicNode
     * @param {UIActionContext} actionContext
     * @memberof GridViewLoadUILogicBase
     */
    executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            switch (logicNode.logicNodeType) {
                case 'BEGIN':
                    console.log(111, '执行开始节点');
                    break;
                case 'END':
                    console.log(111, '执行结束节点');
                    break;
            }
        } catch (error: any) {

        }
    }


}