package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0020;
import cn.ibizlab.core.sample.service.IIBIZSample0020Service;
import cn.ibizlab.core.sample.filter.IBIZSample0020SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"员工" })
@RestController("DemoAPI-ibizsample0020")
@RequestMapping("")
public class IBIZSample0020Resource {

    @Autowired
    public IIBIZSample0020Service ibizsample0020Service;

    @Autowired
    @Lazy
    public IBIZSample0020Mapping ibizsample0020Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0020Mapping.toDomain(#ibizsample0020dto),'DemoSys-IBIZSample0020-Create')")
    @ApiOperation(value = "新建员工", tags = {"员工" },  notes = "新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0020s")
    public ResponseEntity<IBIZSample0020DTO> create(@Validated @RequestBody IBIZSample0020DTO ibizsample0020dto) {
        IBIZSample0020 domain = ibizsample0020Mapping.toDomain(ibizsample0020dto);
		ibizsample0020Service.create(domain);
        IBIZSample0020DTO dto = ibizsample0020Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Mapping.toDomain(#ibizsample0020dtos),'DemoSys-IBIZSample0020-Create')")
    @ApiOperation(value = "批量新建员工", tags = {"员工" },  notes = "批量新建员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0020s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0020DTO> ibizsample0020dtos) {
        ibizsample0020Service.createBatch(ibizsample0020Mapping.toDomain(ibizsample0020dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0020" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0020Service.get(#ibizsample0020_id),'DemoSys-IBIZSample0020-Update')")
    @ApiOperation(value = "更新员工", tags = {"员工" },  notes = "更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0020s/{ibizsample0020_id}")
    public ResponseEntity<IBIZSample0020DTO> update(@PathVariable("ibizsample0020_id") String ibizsample0020_id, @RequestBody IBIZSample0020DTO ibizsample0020dto) {
		IBIZSample0020 domain  = ibizsample0020Mapping.toDomain(ibizsample0020dto);
        domain .setIbizsample0020id(ibizsample0020_id);
		ibizsample0020Service.update(domain );
		IBIZSample0020DTO dto = ibizsample0020Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Service.getIbizsample0020ByEntities(this.ibizsample0020Mapping.toDomain(#ibizsample0020dtos)),'DemoSys-IBIZSample0020-Update')")
    @ApiOperation(value = "批量更新员工", tags = {"员工" },  notes = "批量更新员工")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0020s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0020DTO> ibizsample0020dtos) {
        ibizsample0020Service.updateBatch(ibizsample0020Mapping.toDomain(ibizsample0020dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Service.get(#ibizsample0020_id),'DemoSys-IBIZSample0020-Remove')")
    @ApiOperation(value = "删除员工", tags = {"员工" },  notes = "删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0020s/{ibizsample0020_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0020_id") String ibizsample0020_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0020Service.remove(ibizsample0020_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Service.getIbizsample0020ByIds(#ids),'DemoSys-IBIZSample0020-Remove')")
    @ApiOperation(value = "批量删除员工", tags = {"员工" },  notes = "批量删除员工")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0020s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0020Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0020Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0020-Get')")
    @ApiOperation(value = "获取员工", tags = {"员工" },  notes = "获取员工")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0020s/{ibizsample0020_id}")
    public ResponseEntity<IBIZSample0020DTO> get(@PathVariable("ibizsample0020_id") String ibizsample0020_id) {
        IBIZSample0020 domain = ibizsample0020Service.get(ibizsample0020_id);
        IBIZSample0020DTO dto = ibizsample0020Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取员工草稿", tags = {"员工" },  notes = "获取员工草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0020s/getdraft")
    public ResponseEntity<IBIZSample0020DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0020Mapping.toDto(ibizsample0020Service.getDraft(new IBIZSample0020())));
    }

    @ApiOperation(value = "检查员工", tags = {"员工" },  notes = "检查员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0020s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0020DTO ibizsample0020dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0020Service.checkKey(ibizsample0020Mapping.toDomain(ibizsample0020dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Mapping.toDomain(#ibizsample0020dto),'DemoSys-IBIZSample0020-Save')")
    @ApiOperation(value = "保存员工", tags = {"员工" },  notes = "保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0020s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0020DTO ibizsample0020dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0020Service.save(ibizsample0020Mapping.toDomain(ibizsample0020dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0020Mapping.toDomain(#ibizsample0020dtos),'DemoSys-IBIZSample0020-Save')")
    @ApiOperation(value = "批量保存员工", tags = {"员工" },  notes = "批量保存员工")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0020s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0020DTO> ibizsample0020dtos) {
        ibizsample0020Service.saveBatch(ibizsample0020Mapping.toDomain(ibizsample0020dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0020-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"员工" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0020s/fetchdefault")
	public ResponseEntity<List<IBIZSample0020DTO>> fetchDefault(IBIZSample0020SearchContext context) {
        Page<IBIZSample0020> domains = ibizsample0020Service.searchDefault(context) ;
        List<IBIZSample0020DTO> list = ibizsample0020Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0020-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0020-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"员工" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0020s/searchdefault")
	public ResponseEntity<Page<IBIZSample0020DTO>> searchDefault(@RequestBody IBIZSample0020SearchContext context) {
        Page<IBIZSample0020> domains = ibizsample0020Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0020Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

