/**
 * TreeTable 部件模型
 *
 * @export
 * @class TreeTableModel
 */
export default class TreeTableModel {

	/**
	 * 日历项类型
	 *
	 * @returns {any[]}
	 * @memberof TreeTableTreegridexMode
	 */
	public itemType: string = "";

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof TreeTableTreegridexMode
	 */
	public getDataItems(): any[] {
     let dataItems: any = [
          // 前端新增修改标识，新增为"0",修改为"1"或未设值
          {
            name: 'srffrontuf',
            prop: 'srffrontuf',
            dataType: 'TEXT',
          },
          {
            name: 'style',
          },
          {
            name: 'textColor',
          },
          {
            name: 'itemType',
          },
          {
            name: 'parentId'
          },
          {
            name: 'query',
            prop: 'query',
          },
      ];
      switch(this.itemType){
          case "top1":
              dataItems = [...dataItems,
                  {
                    name: 'id',
                    prop: 'ibizbookid'
                  },
                  {
                    name: 'author',
                    prop: 'author'
                  },
                  {
                    name: 'ibizbookname',
                    prop: 'ibizbookname'
                  },
                  {
                    name: 'subtext',
                    prop: 'subtext'
                  },
              ];
              break;
      }
      return dataItems;
	}

}