/**
 * GroupByCodelistKanBan 部件模型
 *
 * @export
 * @class GroupByCodelistKanBanModel
 */
export default class GroupByCodelistKanBanModel {

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof GroupByCodelistKanBanKanbanMode
	 */
	public getDataItems(): any[] {
		return [
			{
				name: 'author',
				prop: 'author',
				dataType: 'TEXT',
			},
			{
				name: 'srfsubtext',
				prop: 'subtext',
				dataType: 'TEXT',
			},
			{
				name: 'press',
				prop: 'press',
				dataType: 'TEXT',
			},
			{
				name: 'price',
				prop: 'price',
				dataType: 'FLOAT',
			},
			{
				name: 'srficon',
				prop: 'icon',
				dataType: 'TEXT',
			},
			{
				name: 'booknumber',
				prop: 'booknumber',
				dataType: 'INT',
			},
			{
				name: 'type',
				prop: 'type',
				dataType: 'TEXT',
			},
			{
				name: 'srfmstag',
			},
			{
				name: 'srfkey',
				prop: 'ibizbookid',
				dataType: 'GUID',
			},
			{
				name: 'srfmajortext',
				prop: 'ibizbookname',
				dataType: 'TEXT',
			},

			{
				name: 'ibizbook',
				prop: 'ibizbookid',
				dataType: 'FONTKEY',
			},

      {
        name: 'n_ibizbookname_like',
        prop: 'n_ibizbookname_like',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'n_price_gtandeq',
        prop: 'n_price_gtandeq',
        dataType: 'QUERYPARAM'
      },


      {
        name:'size',
        prop:'size'
      },
      {
        name:'query',
        prop:'query'
      },
      {
        name:'sort',
        prop:'sort'
      },
      {
        name:'page',
        prop:'page'
      },
      {
        name:'srfparentdata',
        prop:'srfparentdata'
      },
      // 前端新增修改标识，新增为"0",修改为"1"或未设值
      {
        name: 'srffrontuf',
        prop: 'srffrontuf',
        dataType: 'TEXT',
      },
		]
	}

}