/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'amount',
          prop: 'amount',
          dataType: 'INT',
        },
        {
          name: 'instanceaddress',
          prop: 'instanceaddress',
          dataType: 'TEXT',
        },
        {
          name: 'ibizappviewid',
          prop: 'ibizappviewid',
          dataType: 'GUID',
        },
        {
          name: 'documentaddress',
          prop: 'documentaddress',
          dataType: 'TEXT',
        },
        {
          name: 'ibizappviewtype',
          prop: 'ibizappviewtype',
          dataType: 'TEXT',
        },
        {
          name: 'ibizappviewname',
          prop: 'ibizappviewname',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'ibizappviewname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'ibizappviewid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'ibizappviewid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'viewdescription',
          prop: 'viewdescription',
          dataType: 'TEXT',
        },
        {
          name: 'ibizappview',
          prop: 'ibizappviewid',
        },

        {
          name:'size',
          prop:'size',
          dataType: 'QUERYPARAM'
        },
        {
          name:'query',
          prop:'query',
          dataType: 'QUERYPARAM'
        },
        {
          name:'filter',
          prop:'filter',
          dataType: 'QUERYPARAM'
        },
        {
          name:'page',
          prop:'page',
          dataType: 'QUERYPARAM'
        },
        {
          name:'sort',
          prop:'sort',
          dataType: 'QUERYPARAM'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata',
          dataType: 'QUERYPARAM'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}